/*
    (C) 2001 Anders Holmberg

    This file is part of PocketClive.

    PocketClive is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PocketClive is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PocketClive; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author contact information : aagholmberg@yahoo.se

    PocketClive uses code and inspiration from the following sources 
    (see AUTHORS.TXT for more details) :

    FUSE - The Free Unix Spectrum Emulator - (C) 1999-2001 Philip Kendall
		
    EasyCE - PocketPC game programming library - (C) 2001 Jacco Bikker

    MESS - Multi-Emulator Super System - (C) 1998-2001 MESS Team

    Note : Source code files present in the sub directory PocketClive\EasyCE
           does not comply with the GPL license. These files are (C) Jacco Bikker
           with the following attachment : 

           "If you want to use EasyCE for commercial applications
            you should let me know. I will ask you a small fee,
            since I spend a lot of time developing this software.
            For freeware products, EasyCE can be used freely."
*/


#include "pocket_clive.h"
#include "spectrum_128k.h"
#include "FUSE\keyboard.h"

BYTE spectrum_128k_read_port(WORD port)
{
	if( ( port & 0x0001 ) == 0 )
		return keyboard_read( port >> 8 );
	else if( ( port & 0x00e0 ) == 0 )
		return joystick;
  else
		return 0x01;
}

void spectrum_128k_write_port(WORD port, BYTE b)
{
	if( port == 0x7ffd )
	{
	  machine.ram_page = b & 0x07;
	  machine.rom_page = ( b & 0x10 ) >> 4;
	  machine.screen_page = ( b & 0x08 ) ? 7 : 5;
	}
}

BYTE spectrum_128k_read_memory(WORD address)
{
  WORD bank;

  if( address < 0x4000 ) 
		return rom[ machine.rom_page ][ address ];

	bank    = address / 0x4000; 
	address -= ( bank * 0x4000 );
  
	switch(bank) 
	{
		case 1: 
			return ram[ 5 ][ address ]; 
			break;
		case 2: 
			return ram[ 2 ][ address ];
			break;
		case 3: 
			return ram[ machine.ram_page ][ address ]; 
			break;
		default:
			return 0x00;
			break;
  }
}

void spectrum_128k_write_memory(WORD address, BYTE b)
{
  WORD bank;

  if( address >= 0x4000 ) 
	{	
		bank    = address / 0x4000; 
		address -= ( bank * 0x4000 );
    switch(bank) 
		{
			case 1: 
				bank=5;                                 
				break;
			case 2: 
				bank=2;
				break;
			case 3: 
				bank=machine.ram_page; 
				break;
    }
    ram[ bank ][ address ] = b;
  }
}

