/*
    (C) 2001 Anders Holmberg

    This file is part of PocketClive.

    PocketClive is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PocketClive is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PocketClive; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author contact information : aagholmberg@yahoo.se

    PocketClive uses code and inspiration from the following sources 
    (see AUTHORS.TXT for more details) :

    FUSE - The Free Unix Spectrum Emulator - (C) 1999-2001 Philip Kendall
		
    EasyCE - PocketPC game programming library - (C) 2001 Jacco Bikker

    MESS - Multi-Emulator Super System - (C) 1998-2001 MESS Team

    Note : Source code files present in the sub directory PocketClive\EasyCE
           does not comply with the GPL license. These files are (C) Jacco Bikker
           with the following attachment : 

           "If you want to use EasyCE for commercial applications
            you should let me know. I will ask you a small fee,
            since I spend a lot of time developing this software.
            For freeware products, EasyCE can be used freely."
*/

#ifndef I_TGAFILE
#define I_TGAFILE

#define PIXEL unsigned short			// 16bit pixel
#define IPIXEL unsigned char			// palettized pixel

typedef unsigned short ACHAR;

class ATgaFile
{
public:
	ATgaFile();
	~ATgaFile();
	static bool load( ACHAR* file, int w, int h, IPIXEL* dest, PIXEL* pal = 0 );
	static bool load( ACHAR* file, int w, int h, PIXEL* dest );
	static void ATgaFile::parseheader( unsigned char* a_Header );
private:
	static int s_IDLen;		// Length of Image Descriptor field
	static int s_CMapType;	// Color map type
	static int s_ImgType;	// Image type; 1 = indexed, 2 = RGB, others are compressed
	static int s_CMapOrig;	// Index of first color map entry
	static int s_CMapLen;	// Number of colors in color map
	static int s_CMapSize;	// Size of single color in color map (in bits)
	static int s_XPos;		// X-Coord of lower left corner
	static int s_YPos;		// Y-Coord of lower left corner
	static int s_Width;		// Width of the image
	static int s_Height;	// Height of the image
	static int s_PixSize;	// Bits per pixel in image map
};

class SpectrumFile
{
public:
	SpectrumFile();
	~SpectrumFile();
	static bool load_scr( ACHAR *file, unsigned char *dest );
	static bool load_rom( char *file, unsigned char *dest );
	static bool load_snap( ACHAR *file, unsigned char *dest );
};

extern bool load( char *file_name, int size, unsigned char *dest );

#endif

// ------------------------------------------------
// EOF