/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;

public class Ruscell
extends Applet
implements Runnable {
    Panel pTop;
    Panel pTopLeft;
    Button bNewGame;
    Button bUndo;
    RuscellDesk playArea;
    Label results;
    Thread runThread = null;
    boolean firstTime = true;
    boolean pauseInEffect = false;
    boolean gameOnDisplay = false;
    int gamesPlayed = 0;
    int gamesWon = 0;
    int gamesLostInARow = 0;
    int gamesWonInARow = 0;
    int gamesCurrentStreak = 0;

    public boolean action(Event event, Object object) {
        Object object2 = event.target;
        if (object2 == this.bNewGame) {
            if (this.playArea.autoInProgress || this.playArea.undoInProgress || this.playArea.moveInProgress) {
                return true;
            }
            this.playArea.flagMoveStored = false;
            if (this.gameOnDisplay) {
                this.updateScore(false);
            }
            this.gameOnDisplay = true;
            this.playArea.dealHand();
            return true;
        }
        if (object2 == this.bUndo) {
            return this.playArea.undo();
        }
        return false;
    }

    void dispScore() {
        this.results.setText("Games:  Won: " + this.gamesWon + "  Lost: " + (this.gamesPlayed - this.gamesWon));
    }

    public String getAppletInfo() {
        return "Ruscell v.1.05 copyright 2000 By-art.com";
    }

    public void init() {
    }

    public boolean keyDown(Event event, int n) {
        if (n == 26) {
            return this.playArea.undo();
        }
        if (n == 1009) {
            if (this.playArea.autoInProgress || this.playArea.undoInProgress || this.playArea.moveInProgress) {
                return true;
            }
            this.playArea.flagMoveStored = false;
            if (this.gameOnDisplay) {
                this.updateScore(false);
            }
            this.gameOnDisplay = true;
            this.playArea.dealHand();
            return true;
        }
        return false;
    }

    public void run() {
        while (Thread.currentThread() == this.runThread) {
            if (this.playArea.moveInProgress) {
                this.playArea.move();
            } else if (this.playArea.autoInProgress) {
                this.playArea.moveAuto();
            } else if (this.playArea.undoInProgress) {
                this.playArea.moveUndo();
            }
            if (!this.gameOnDisplay) {
                this.playArea.doGameOver();
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void setUpDisplay() {
        this.setLayout(new BorderLayout());
        this.pTop = new Panel();
        this.pTop.setLayout(new BorderLayout());
        this.add("South", this.pTop);
        this.pTopLeft = new Panel();
        this.pTop.add("West", this.pTopLeft);
        this.bNewGame = new Button("New (F2)");
        this.pTopLeft.add("West", this.bNewGame);
        this.bUndo = new Button("Undo (Ctrl+z)");
        this.pTopLeft.add("West", this.bUndo);
        this.results = new Label("Loading Card Images", 1);
        this.pTop.add("Center", this.results);
        this.playArea = new RuscellDesk(this);
        this.add("Center", this.playArea);
        this.validate();
    }

    public void start() {
        if (this.firstTime) {
            this.setUpDisplay();
            this.results.setText(" ");
            this.firstTime = false;
        }
        if (this.runThread == null && !this.pauseInEffect) {
            this.runThread = new Thread((Runnable)this, "RusCell");
            this.runThread.start();
        }
    }

    public void stop() {
        this.runThread = null;
    }

    void updateScore(boolean bl) {
        ++this.gamesPlayed;
        if (bl) {
            ++this.gamesWon;
            this.gamesCurrentStreak = this.gamesCurrentStreak >= 0 ? ++this.gamesCurrentStreak : 1;
        } else {
            this.gamesCurrentStreak = this.gamesCurrentStreak <= 0 ? --this.gamesCurrentStreak : -1;
        }
        if (this.gamesCurrentStreak > this.gamesWonInARow) {
            this.gamesWonInARow = this.gamesCurrentStreak;
        }
        if (this.gamesCurrentStreak < 0 && -this.gamesCurrentStreak > this.gamesLostInARow) {
            this.gamesLostInARow = -this.gamesCurrentStreak;
        }
        this.dispScore();
    }
}

