/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

class RusCellStack {
    private int Code;
    private int ConstantValue;
    private int I;
    private int[] RuscellDesk;
    private int setPaintMode;
    private int black;
    private RuscellDesk width;
    private int white = 0;
    private int setXORMode = 0;
    private final int size = 17;

    public RusCellStack(RuscellDesk ruscellDesk, int n, int n2, int n3) {
        this.width = ruscellDesk;
        this.black = n;
        this.setPaintMode = n < 8 ? 2 : (n < 12 ? 0 : 1);
        this.Code = n2;
        this.ConstantValue = n3;
        this.RuscellDesk = new int[21];
        this.reset();
    }

    void addCard(int n) {
        switch (this.setPaintMode) {
            case 0: {
                this.I = 1;
                break;
            }
            case 1: {
                this.I = 1;
                break;
            }
            case 2: {
                ++this.I;
            }
        }
        this.RuscellDesk[this.I - 1] = n;
    }

    public int countMovableSuit() {
        if (this.I <= 1) {
            return this.I;
        }
        int n = 1;
        int n2 = this.I - 1;
        while (n2 > 0) {
            if (!this.width.isCardAllowed(this.RuscellDesk[n2 - 1], this.RuscellDesk[n2])) {
                return n;
            }
            ++n;
            --n2;
        }
        return n;
    }

    void drawCard(Graphics graphics, boolean bl, int n) {
        this.width.paintCard(graphics, bl, this.white, this.setXORMode + n * 17, this.RuscellDesk[n]);
    }

    void drawStack(Graphics graphics) {
        if (this.isEmpty()) {
            this.drawCard(graphics, false, 0);
        } else {
            int n = 0;
            while (n < this.I) {
                this.drawCard(graphics, true, n);
                ++n;
            }
        }
    }

    void drawTopCard(Graphics graphics) {
        if (this.isEmpty()) {
            this.drawCard(graphics, false, 0);
        } else {
            this.drawCard(graphics, true, this.I - 1);
        }
    }

    int getIthCard(int n) {
        return this.RuscellDesk[n];
    }

    int getNCards() {
        return this.I;
    }

    int getType() {
        return this.setPaintMode;
    }

    public boolean isEmpty() {
        return this.I == 0;
    }

    public boolean isInside(int n, int n2) {
        if (n < this.white || n > this.white + this.Code) {
            return false;
        }
        if (n2 < this.setXORMode) {
            return false;
        }
        return this.setPaintMode == 2 || n2 <= this.setXORMode + this.ConstantValue;
    }

    void paintSelection(Graphics graphics) {
        this.drawTopCard(graphics);
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        graphics.fillRect(this.white, this.setXORMode + (this.I - 1) * 17, 71, 105);
        graphics.setPaintMode();
    }

    void putCard(Graphics graphics, int n) {
        this.addCard(n);
        this.drawTopCard(graphics);
    }

    /*
     * Enabled aggressive block sorting
     */
    int removeCard(Graphics graphics) {
        int n = this.topCard();
        switch (this.setPaintMode) {
            case 2: {
                this.drawCard(graphics, false, this.I);
                --this.I;
                this.RuscellDesk[this.I] = -1;
                break;
            }
            case 0: {
                this.RuscellDesk[0] = -1;
                this.I = 0;
                break;
            }
            case 1: {
                switch (this.width.suitNo(n)) {
                    case -1: {
                        this.RuscellDesk[0] = -1;
                        this.I = 0;
                        break;
                    }
                    case 0: {
                        this.RuscellDesk[0] = this.RuscellDesk[0] + 12;
                        break;
                    }
                    default: {
                        this.RuscellDesk[0] = this.RuscellDesk[0] - 1;
                        break;
                    }
                    case -2: 
                }
                break;
            }
        }
        this.drawTopCard(graphics);
        return n;
    }

    public void reset() {
        int n = 0;
        while (n < 21) {
            this.RuscellDesk[n] = -1;
            ++n;
        }
        this.I = 0;
    }

    public void setOffsets(Graphics graphics) {
        Dimension dimension = this.width.size();
        switch (this.setPaintMode) {
            case 0: {
                this.setXORMode = 0;
                this.white = (this.black - 8) * this.Code;
                break;
            }
            case 1: {
                this.setXORMode = 0;
                this.white = dimension.width - (4 - (this.black - 12)) * this.Code;
                break;
            }
            default: {
                this.setXORMode = this.ConstantValue + 3;
                int n = (dimension.width - 8 * this.Code) / 9;
                this.white = n + this.black * (n + this.Code);
            }
        }
    }

    public int topCard() {
        if (this.I < 1) {
            return -1;
        }
        return this.RuscellDesk[this.I - 1];
    }
}

