/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class RSol
extends Applet
implements Runnable,
ActionListener,
ItemListener {
    Panel pBottom;
    Button bNewGame;
    Choice cSingleCard;
    SolDesk Desk;
    Label results;
    boolean flagMoveSingleCard = false;
    private final boolean Center = false;
    Thread runThread = null;
    boolean firstTime = true;
    boolean pauseInEffect = false;
    boolean gameOnDisplay = false;
    int gamesPlayed = 0;
    int score = 0;
    int bestScore = 0;
    boolean showBestScore = false;

    static boolean access$0(RSol rSol) {
        return rSol.Code();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.Desk.autoInProgress || this.Desk.moveInProgress) {
            return;
        }
        if (actionEvent.getSource() == this.bNewGame) {
            this.Code();
        }
    }

    void dispScore() {
        if (this.showBestScore) {
            this.results.setText("Games: " + this.gamesPlayed + "   Score: " + this.score + "   Best score: " + this.bestScore);
        } else {
            this.results.setText("Games: " + this.gamesPlayed + "    Score: " + this.score);
        }
    }

    public String getAppletInfo() {
        return "RSol - Russian solitaire. Version 1.0 (C) G.U.E.S. 2000";
    }

    public String getState() {
        int n = this.flagMoveSingleCard ? 1 : 0;
        String string = String.valueOf(Integer.toString(this.gamesPlayed)) + ',' + Integer.toString(this.score) + ',' + Integer.toString(this.bestScore) + ',' + Integer.toString(n);
        return string;
    }

    public void init() {
        this.enableEvents(8L);
        this.requestFocus();
        this.ConstantValue();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            boolean bl;
            boolean bl2 = bl = this.cSingleCard.getSelectedIndex() != 0;
            if (this.flagMoveSingleCard == bl) {
                return;
            }
            this.flagMoveSingleCard = bl;
            this.Code();
        }
    }

    private boolean Code() {
        if (this.Desk == null) {
            return true;
        }
        if (this.Desk.autoInProgress || this.Desk.moveInProgress) {
            return true;
        }
        this.Desk.flagMoveStored = false;
        this.gameOnDisplay = true;
        this.Desk.dealHand();
        this.updateScore(1, -52);
        this.requestFocus();
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 113) {
            this.Code();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runThread) {
            int n = 40;
            if (this.Desk.moveInProgress) {
                this.Desk.move();
            } else if (this.Desk.autoInProgress) {
                this.Desk.moveAuto();
            }
            if (!this.gameOnDisplay) {
                n = 10;
                this.Desk.doGameOver();
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void ConstantValue() {
        String string = this.getParameter("game");
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.gamesPlayed = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.score = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (this.score < 0) {
                this.score = 0;
            }
            this.bestScore = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.flagMoveSingleCard = n != 0;
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void D() {
        this.setLayout(new BorderLayout());
        this.pBottom = new Panel();
        Color color = new Color(32768);
        this.pBottom.setBackground(color);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.pBottom.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        gridBagConstraints.weightx = 0.0;
        Color color2 = new Color(0x408040);
        this.bNewGame = new Button("New Game");
        this.bNewGame.addActionListener(this);
        gridBagLayout.setConstraints(this.bNewGame, gridBagConstraints);
        this.pBottom.add(this.bNewGame);
        this.cSingleCard = new Choice();
        this.cSingleCard.add("Draw Three");
        this.cSingleCard.add("Draw One");
        if (this.flagMoveSingleCard) {
            this.cSingleCard.select(1);
        }
        this.cSingleCard.addItemListener(this);
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.cSingleCard, gridBagConstraints);
        this.pBottom.add(this.cSingleCard);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.results = new Label("Loading...", 2);
        this.results.setBackground(color);
        this.results.setForeground(Color.yellow);
        gridBagLayout.setConstraints(this.results, gridBagConstraints);
        this.pBottom.add(this.results);
        this.add("South", this.pBottom);
        this.Desk = new SolDesk(this, this);
        this.add("Center", this.Desk);
        this.validate();
    }

    public void start() {
        if (this.firstTime) {
            this.D();
            this.results.setText(" ");
            this.firstTime = false;
        }
        if (this.runThread == null && !this.pauseInEffect) {
            this.runThread = new Thread((Runnable)this, "RSol");
            this.runThread.start();
        }
    }

    public void stop() {
        this.runThread = null;
    }

    void updateScore(int n, int n2) {
        this.gamesPlayed += n;
        this.score += n2;
        if (this.bestScore < this.score) {
            this.bestScore = this.score;
        }
        this.dispScore();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SolDesk
    extends Canvas
    implements ActionListener {
        private final RSol Cards;
        private RSol Code;
        private Cards ConstantValue;
        private int I;
        int flagPaint;
        SolStack[] stack;
        final int typeClose = 0;
        final int typeDone = 1;
        final int typePlay = 2;
        final int typeOpen = 3;
        private SolStack InnerClasses;
        private SolStack RSol;
        private SolStack SolDesk;
        private Color Z;
        private PopupMenu getX;
        private int add;
        private int addActionListener;
        private int addCard;
        private int getType;
        private int isPopupTrigger;
        private boolean black;
        Image iBuffer;
        Graphics g;
        private SolStack[][] getGraphics;
        private int[] getCardImage;
        private int insertSeparator;
        private int getClass;
        boolean flagMoveStored;
        private SolStack overlapArea;
        private SolStack createImage;
        boolean autoInProgress;
        boolean moveInProgress;
        boolean dragInProgress;
        private int currentThread;
        Image selImage;
        Graphics gSel;
        Image savedImage;
        Graphics gSaved;
        private int getSize;
        private int getCardH;
        private int one;
        private int getPositionSelected;
        private int getNCards;
        private int isEmpty;

        public SolDesk(RSol rSol, RSol rSol2) {
            this.Cards = rSol;
            this.ConstantValue = null;
            this.I = 7;
            this.flagPaint = -1;
            this.typeClose = 0;
            this.typeDone = 1;
            this.typePlay = 2;
            this.typeOpen = 3;
            this.add = 0;
            this.addActionListener = 100;
            this.addCard = 0;
            this.getType = 0;
            this.isPopupTrigger = 0;
            this.black = true;
            this.flagMoveStored = false;
            this.overlapArea = null;
            this.createImage = null;
            this.autoInProgress = false;
            this.moveInProgress = false;
            this.dragInProgress = false;
            this.Code = rSol2;
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.Z = new Color(32768);
            this.setBackground(this.Z);
            this.ConstantValue = new Cards(rSol2);
            this.stack = new SolStack[13];
            int n = 0;
            while (n < 13) {
                RSol rSol3 = rSol;
                rSol3.getClass();
                this.stack[n] = new SolStack(rSol3, this, n, this.ConstantValue.getCardW(), this.ConstantValue.getCardH());
                ++n;
            }
            this.InnerClasses = this.stack[11];
            this.RSol = this.stack[12];
            RSol rSol4 = rSol;
            rSol4.getClass();
            this.SolDesk = new SolStack(rSol4, this, 0, 0, 0);
            this.getGraphics = new SolStack[100][2];
            this.getCardImage = new int[100];
            String[] stringArray = new String[]{"New Game", "Draw One", "Draw Three"};
            String[] stringArray2 = new String[]{"new", "one", "three"};
            this.getX = new PopupMenu();
            int n2 = 0;
            while (n2 < stringArray.length) {
                MenuItem menuItem = new MenuItem(stringArray[n2]);
                menuItem.setActionCommand(stringArray2[n2]);
                menuItem.addActionListener(this);
                this.getX.add(menuItem);
                ++n2;
            }
            this.getX.insertSeparator(1);
            this.add(this.getX);
            this.gameOnDisplay();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("new")) {
                RSol.access$0(this.Cards);
            } else if (string.equals("one")) {
                this.Cards.flagMoveSingleCard = true;
                RSol.access$0(this.Cards);
            } else if (string.equals("three")) {
                this.Cards.flagMoveSingleCard = false;
                RSol.access$0(this.Cards);
            }
        }

        private void imageNoCard(SolStack solStack, SolStack solStack2, int n) {
            this.getGraphics[this.getClass][0] = solStack;
            this.getGraphics[this.getClass][1] = solStack2;
            this.getCardImage[this.getClass] = n;
            ++this.getClass;
        }

        public void dealHand() {
            this.gameOnDisplay();
            boolean[] blArray = new boolean[52];
            int n = 0;
            while (n < 52) {
                blArray[n] = false;
                ++n;
            }
            this.add = 0;
            int n2 = 0;
            while (n2 < 52) {
                n = (int)(Math.random() * 52.0);
                if (n > 51) {
                    n = 0;
                }
                while (blArray[n]) {
                    if (++n <= 51) continue;
                    n = 0;
                }
                blArray[n] = true;
                int n3 = n2 / 7;
                int n4 = n2 % 7;
                if (n3 > n4) {
                    this.InnerClasses.addCard(n, false);
                } else if (n3 == n4) {
                    this.stack[n4].addCard(n, true);
                } else {
                    this.stack[n4].addCard(n, false);
                }
                ++n2;
            }
            this.flagPaint = -1;
            this.repaint();
        }

        private void gameOnDisplay() {
            int n = 0;
            while (n < 13) {
                this.stack[n].reset();
                ++n;
            }
            this.overlapArea = null;
            this.resetProgressFlags();
            this.flagPaint = -1;
        }

        public void doGameOver() {
            if (this.flagPaint != -1) {
                return;
            }
            this.flagPaint = 11;
            this.repaint();
        }

        private void getActionCommand(Graphics graphics) {
            if (this.isPopupTrigger++ % 20 == 0) {
                this.getType = this.drawTopCard(0, 51);
            }
            Dimension dimension = this.getSize();
            this.addActionListener += 3;
            this.addCard += 3;
            int n = dimension.width - 1 - 71;
            int n2 = dimension.height - 1 - 105 - 1;
            int n3 = (this.addActionListener / n & 1) != 0 ? this.addActionListener % n : n - 1 - this.addActionListener % n;
            int n4 = (this.addCard / n2 & 1) != 0 ? this.addCard % n2 : n2 - 1 - this.addCard % n2;
            graphics.drawImage(this.ConstantValue.getCardImage(this.getType), n3, n4, this);
        }

        void drawSelectionImage(Graphics graphics, int n, int n2, int n3, int n4) {
            this.selImage = this.createImage(n3, n4);
            this.gSel = this.selImage.getGraphics();
            this.gSel.drawImage(this.iBuffer, -n, -n2, this);
            this.SolDesk.reset();
            int n5 = this.currentThread;
            while (n5 < this.overlapArea.getNCards()) {
                this.SolDesk.addCard(this.overlapArea.getIthCard(n5), true);
                ++n5;
            }
            int n6 = this.overlapArea.getNCards() - 1;
            while (n6 >= this.currentThread) {
                this.overlapArea.removeCard(graphics);
                --n6;
            }
            this.savedImage = this.createImage(n3, n4);
            this.gSaved = this.savedImage.getGraphics();
            this.gSaved.drawImage(this.iBuffer, -n, -n2, this);
            graphics.drawImage(this.selImage, n, n2, this);
        }

        boolean gameLost() {
            return false;
        }

        boolean gameOver() {
            int n = 7;
            while (n < 11) {
                if (this.stack[n].getNCards() != 13) {
                    return false;
                }
                ++n;
            }
            this.Code.gameOnDisplay = false;
            return true;
        }

        private int height() {
            int n = 1;
            if (!this.Code.flagMoveSingleCard) {
                n = 3;
            }
            if (n > this.InnerClasses.getNCards()) {
                n = this.InnerClasses.getNCards();
            }
            return n;
        }

        private boolean getY(int n, int n2) {
            return n2 == -1 ? this.flagMoveSingleCard(n) == -1 : n / 13 == n2 / 13 && this.flagMoveSingleCard(n) == this.flagMoveSingleCard(n2) + 1;
        }

        private boolean getYPos(int n, int n2) {
            if (this.fillRect(n) == this.fillRect(n2)) {
                return false;
            }
            return this.flagMoveSingleCard(n) == this.flagMoveSingleCard(n2) + 1;
        }

        private boolean getXPos(SolStack solStack, SolStack solStack2, int n) {
            if (solStack == null) {
                return false;
            }
            if (solStack == solStack2) {
                return false;
            }
            if (solStack2 == this.RSol) {
                return false;
            }
            if (solStack.isEmpty()) {
                return false;
            }
            if (solStack.isTopCardClosed()) {
                return false;
            }
            switch (solStack2.getType()) {
                case 1: {
                    if (n != solStack.getNCards() - 1) {
                        return false;
                    }
                    return this.getY(solStack.topCard(), solStack2.topCard());
                }
                case 2: {
                    if (solStack2.isEmpty()) {
                        if (this.flagMoveSingleCard(solStack.getIthCard(n)) != 11) break;
                        return true;
                    }
                    if (solStack2.isTopCardClosed()) break;
                    return this.getYPos(solStack2.topCard(), solStack.getIthCard(n));
                }
            }
            return false;
        }

        private boolean drawImage(int n, int n2) {
            if (!this.Code.gameOnDisplay) {
                return false;
            }
            if (this.autoInProgress || this.moveInProgress) {
                return false;
            }
            if (this.flagPaint != -1) {
                return false;
            }
            int n3 = 0;
            while (n3 < 13) {
                int n4 = this.stack[n3].getPositionSelected(n, n2);
                switch (n4) {
                    case -2: {
                        if (this.stack[n3] != this.InnerClasses) break;
                        return this.eraseStack(this.stack[n3], null, 0);
                    }
                    default: {
                        if (this.stack[n3].isTopCardClosed()) {
                            return this.eraseStack(this.stack[n3], null, 0);
                        }
                        this.overlapArea = this.stack[n3];
                        this.dragInProgress = true;
                        this.currentThread = n4;
                        this.flagPaint = 2;
                        this.getSize = this.stack[n3].getXPos(n4);
                        this.getCardH = this.stack[n3].getYPos(n4);
                        this.getNCards = n - this.getSize;
                        this.isEmpty = n2 - this.getCardH;
                        this.repaint();
                        return true;
                    }
                    case -1: 
                }
                ++n3;
            }
            return false;
        }

        private boolean getIthCard(int n, int n2) {
            if (!this.dragInProgress || this.flagPaint != -1) {
                return false;
            }
            this.one = n - this.getNCards;
            this.getPositionSelected = n2 - this.isEmpty;
            this.flagPaint = 7;
            this.repaint();
            return false;
        }

        private boolean drawRect(int n, int n2) {
            if (!this.dragInProgress) {
                return false;
            }
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            while (n5 < 13) {
                int n6;
                if (this.getXPos(this.SolDesk, this.stack[n5], 0) && (n6 = this.stack[n5].overlapArea(this.one, this.getPositionSelected)) > n3) {
                    n3 = n6;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 >= 0) {
                this.equals(this.stack[n4]);
            } else {
                this.equals(null);
            }
            return false;
        }

        void move() {
            if (this.flagPaint != -1) {
                return;
            }
            this.flagPaint = 4;
            this.repaint();
        }

        void moveAuto() {
            if (this.flagPaint != -1) {
                return;
            }
            this.flagPaint = 5;
            this.repaint();
        }

        void moveAutoCard(Graphics graphics) {
            int n = 13;
            int n2 = 7;
            while (n2 < 11) {
                if (this.flagMoveSingleCard(this.stack[n2].topCard()) < n) {
                    n = this.flagMoveSingleCard(this.stack[n2].topCard());
                }
                ++n2;
            }
            ++n;
            int n3 = 0;
            while (n3 < 13) {
                int n4;
                int n5 = this.stack[n3].getType();
                if (!(n5 != 3 && n5 != 2 || (n4 = this.stack[n3].topCard()) == -1 || this.stack[n3].isTopCardClosed())) {
                    int n6;
                    if (this.flagMoveSingleCard(n4) == n) {
                        n6 = 7;
                        while (n6 < 11) {
                            if (this.stack[n6].isEmpty()) {
                                this.putAndMoveCard(graphics, this.stack[n3], this.stack[n6]);
                                return;
                            }
                            if (n4 / 13 == this.stack[n6].topCard() / 13) {
                                this.putAndMoveCard(graphics, this.stack[n3], this.stack[n6]);
                                return;
                            }
                            ++n6;
                        }
                    } else if (this.flagMoveSingleCard(n4) == n + 1) {
                        n6 = 7;
                        while (n6 < 11) {
                            if (!this.stack[n6].isEmpty() && this.flagMoveSingleCard(n4) == this.flagMoveSingleCard(this.stack[n6].topCard()) + 1 && n4 / 13 == this.stack[n6].topCard() / 13) {
                                this.putAndMoveCard(graphics, this.stack[n3], this.stack[n6]);
                                return;
                            }
                            ++n6;
                        }
                    }
                }
                ++n3;
            }
            this.autoInProgress = false;
            this.insertSeparator = this.getClass - 1;
            this.flagMoveStored = true;
            if (this.gameOver()) {
                this.Code.updateScore(1, 0);
                this.Code.gameOnDisplay = false;
                this.flagMoveStored = false;
            }
        }

        void moveCardFromSrcToDst(Graphics graphics, SolStack solStack, SolStack solStack2, int n) {
            if (solStack2 == null) {
                int n2;
                if (solStack.getType() == 2) {
                    n2 = solStack.removeCard(graphics);
                    solStack.putCard(graphics, n2, true);
                }
                if (solStack.getType() == 0) {
                    if (solStack.isEmpty()) {
                        if (!this.RSol.isEmpty()) {
                            if (!this.new()) {
                                this.Code.updateScore(0, this.Cards.flagMoveSingleCard ? -60 : -20);
                            }
                            n2 = this.RSol.getNCards();
                            int n3 = 0;
                            while (n3 < n2) {
                                solStack.putCard(graphics, this.RSol.removeCard(graphics), false);
                                ++n3;
                            }
                            this.RSol.setOpenIndex(0);
                        }
                    } else {
                        n2 = this.height();
                        this.RSol.eraseStack(graphics);
                        this.RSol.setOpenIndex(0);
                        int n4 = 0;
                        while (n4 < n2) {
                            this.RSol.putCard(graphics, solStack.removeCard(graphics), true);
                            ++n4;
                        }
                        if (this.InnerClasses.isEmpty()) {
                            ++this.add;
                            this.InnerClasses.drawTopCard(graphics);
                        }
                    }
                }
            } else {
                int n5 = n;
                while (n5 < solStack.getNCards()) {
                    solStack2.putCard(graphics, solStack.getIthCard(n5), true);
                    ++n5;
                }
                int n6 = solStack.getNCards() - 1;
                while (n6 >= n) {
                    solStack.removeCard(graphics);
                    --n6;
                }
                if (solStack.getType() == 1) {
                    this.Code.updateScore(0, -5);
                }
                if (solStack2.getType() == 1) {
                    this.Code.updateScore(0, 5);
                }
            }
        }

        public void paint(Graphics graphics) {
            if (this.flagPaint != -1) {
                return;
            }
            this.update(graphics);
        }

        void paintCard(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
            if (bl && n3 >= 0) {
                graphics.drawImage(this.ConstantValue.getCardImage(n3), n, n2, this);
            } else {
                graphics.setColor(this.Z);
                graphics.fillRect(n, n2, this.ConstantValue.getCardW() + 1, this.ConstantValue.getCardH() + 1);
                if (n4 == 0 && !this.isTopCardClosed()) {
                    graphics.drawImage(this.ConstantValue.imageNoCard, n, n2, this);
                }
                if (n2 == 2) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(n, n2, this.ConstantValue.getCardW() - 1, this.ConstantValue.getCardH() - 1);
                }
            }
        }

        private void getID(Graphics graphics) {
            int n = 0;
            while (n < this.SolDesk.getNCards()) {
                this.overlapArea.addCard(this.SolDesk.getIthCard(n), true);
                ++n;
            }
            graphics.drawImage(this.savedImage, this.getSize, this.getCardH, this);
            if (this.createImage != null && this.createImage != this.overlapArea) {
                this.eraseStack(this.overlapArea, this.createImage, this.currentThread);
            } else {
                this.overlapArea.drawStack(graphics);
            }
        }

        private void drawStack(Graphics graphics) {
            graphics.drawImage(this.savedImage, this.getSize, this.getCardH, this);
            this.gSaved.drawImage(this.iBuffer, -this.one, -this.getPositionSelected, this);
            this.getSize = this.one;
            this.getCardH = this.getPositionSelected;
            graphics.drawImage(this.selImage, this.one, this.getPositionSelected, this);
        }

        void paintEveryThing(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.Z);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n = 0;
            while (n < 13) {
                this.stack[n].drawStack(graphics);
                ++n;
            }
        }

        void paintMove(Graphics graphics) {
            if (!this.moveInProgress) {
                return;
            }
            this.moveCardFromSrcToDst(graphics, this.getGraphics[this.insertSeparator][0], this.getGraphics[this.insertSeparator][1], this.getCardImage[this.insertSeparator]);
            ++this.insertSeparator;
            if (this.insertSeparator >= this.getClass) {
                this.moveInProgress = false;
                this.autoInProgress = true;
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (!this.autoInProgress && !this.moveInProgress) {
                    this.getX.show(this, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
            } else if (mouseEvent.getID() == 501 ? this.drawImage(mouseEvent.getX(), mouseEvent.getY()) : mouseEvent.getID() == 502 && this.drawRect(mouseEvent.getX(), mouseEvent.getY())) {
                return;
            }
            super.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506 && this.getIthCard(mouseEvent.getX(), mouseEvent.getY())) {
                return;
            }
            super.processMouseMotionEvent(mouseEvent);
        }

        void putAndMoveCard(Graphics graphics, SolStack solStack, SolStack solStack2) {
            try {
                Thread.currentThread();
                Thread.sleep(80L);
            }
            catch (Exception exception) {}
            this.moveCardFromSrcToDst(graphics, solStack, solStack2, solStack.getNCards() - 1);
            this.getGraphics[this.getClass][0] = solStack;
            this.getGraphics[this.getClass][1] = solStack2;
            this.getCardImage[this.getClass] = solStack.getNCards() - 1;
            ++this.getClass;
        }

        private int drawTopCard(int n, int n2) {
            return (int)(Math.random() * (double)(n2 - n + 1)) + n;
        }

        public void resetProgressFlags() {
            this.moveInProgress = false;
            this.autoInProgress = false;
            this.dragInProgress = false;
        }

        private void enableEvents(Graphics graphics) {
            if (this.overlapArea == null) {
                return;
            }
            this.overlapArea.paintSelection(graphics, this.currentThread);
        }

        private void equals(SolStack solStack) {
            this.createImage = solStack;
            this.dragInProgress = false;
            this.flagPaint = 8;
            this.repaint();
        }

        private boolean eraseStack(SolStack solStack, SolStack solStack2, int n) {
            this.flagMoveStored = false;
            this.autoInProgress = false;
            this.moveInProgress = true;
            this.getClass = 0;
            this.insertSeparator = 0;
            this.imageNoCard(solStack, solStack2, n);
            this.overlapArea = null;
            return true;
        }

        private int fillRect(int n) {
            int n2 = n / 13;
            if (n2 == 0 || n2 == 1) {
                return 0;
            }
            return 1;
        }

        private int flagMoveSingleCard(int n) {
            if (n < 0) {
                return -2;
            }
            int n2 = n % 13;
            if (n2 == 12) {
                n2 = -1;
            }
            return n2;
        }

        private boolean isTopCardClosed() {
            int n;
            SolStack solStack;
            int n2;
            if (!this.InnerClasses.isEmpty()) {
                return true;
            }
            int n3 = 0;
            while (n3 < 13) {
                SolStack solStack2 = this.stack[n3];
                if (solStack2.getType() == 2 && !solStack2.isEmpty()) {
                    if (solStack2.isTopCardClosed()) {
                        return true;
                    }
                    n2 = 0;
                    while (n2 < 13) {
                        if (n2 != n3) {
                            solStack = this.stack[n2];
                            switch (solStack.getType()) {
                                case 1: {
                                    if (!this.getXPos(solStack2, solStack, solStack2.getNCards() - 1)) break;
                                    return true;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                ++n3;
            }
            int n4 = n = this.Code.flagMoveSingleCard ? 1 : 3;
            if (this.RSol.getNCards() > 0) {
                n2 = 0;
                while (n2 < 13) {
                    solStack = this.stack[n2];
                    switch (solStack.getType()) {
                        case 2: {
                            n3 = n - 1;
                            while (n3 < this.RSol.getNCards()) {
                                if (solStack.isEmpty() && this.flagMoveSingleCard(this.RSol.getIthCard(n3)) == 11) {
                                    return true;
                                }
                                if (this.getYPos(solStack.topCard(), this.RSol.getIthCard(n3))) {
                                    return true;
                                }
                                n3 += n;
                            }
                            if (solStack.isEmpty() && this.flagMoveSingleCard(this.RSol.topCard()) == 11) {
                                return true;
                            }
                            if (!this.getYPos(solStack.topCard(), this.RSol.topCard())) break;
                            return true;
                        }
                        case 1: {
                            n3 = n - 1;
                            while (n3 < this.RSol.getNCards()) {
                                if (this.getY(this.RSol.getIthCard(n3), solStack.topCard())) {
                                    return true;
                                }
                                n3 += n;
                            }
                            if (!this.getY(this.RSol.topCard(), solStack.topCard())) break;
                            return true;
                        }
                    }
                    ++n2;
                }
            }
            return false;
        }

        private boolean new() {
            int n = 3;
            if (this.Code.flagMoveSingleCard) {
                n = 1;
            }
            return this.add < n;
        }

        public void update(Graphics graphics) {
            if (this.black) {
                Dimension dimension = this.getSize();
                this.iBuffer = this.createImage(dimension.width, dimension.height);
                this.g = this.iBuffer.getGraphics();
                int n = 0;
                while (n < 13) {
                    this.stack[n].setOffsets(this.g);
                    ++n;
                }
                this.black = false;
            }
            if (this.flagPaint == 10) {
                return;
            }
            int n = this.flagPaint;
            this.flagPaint = 10;
            switch (n) {
                case -1: 
                case 0: {
                    this.paintEveryThing(this.g);
                    break;
                }
                case 2: {
                    this.enableEvents(this.g);
                    break;
                }
                case 4: {
                    this.paintMove(this.g);
                    break;
                }
                case 5: {
                    this.moveAutoCard(this.g);
                    break;
                }
                case 7: {
                    this.drawStack(this.g);
                    break;
                }
                case 8: {
                    this.getID(this.g);
                    break;
                }
                case 11: {
                    this.getActionCommand(this.g);
                    break;
                }
                case 12: {
                    this.InnerClasses.drawStack(this.g);
                    break;
                }
            }
            graphics.drawImage(this.iBuffer, 0, 0, this);
            this.flagPaint = -1;
        }
    }

    class SolStack {
        private final RSol Code;
        private int ConstantValue;
        private int I;
        private int InnerClasses;
        private int[] RSol;
        private int SolStack;
        private int paintCard;
        private int width;
        private int min;
        private SolDesk max;
        private final int getSize = 25;
        final int typeClose = 0;
        final int typeDone = 1;
        final int typePlay = 2;
        final int typeOpen = 3;
        private int drawSelectionImage;
        private int A;
        private int B;
        private int C;

        public SolStack(RSol rSol, SolDesk solDesk, int n, int n2, int n3) {
            this.Code = rSol;
            this.getSize = 25;
            this.typeClose = 0;
            this.typeDone = 1;
            this.typePlay = 2;
            this.typeOpen = 3;
            this.drawSelectionImage = 0;
            this.A = 0;
            this.B = 17;
            this.C = 20;
            this.max = solDesk;
            this.width = n;
            this.paintCard = n < 7 ? 2 : (n < 11 ? 1 : (n == 11 ? 0 : 3));
            this.ConstantValue = n2;
            this.I = n3;
            this.RSol = new int[25];
            this.reset();
        }

        void addCard(int n, boolean bl) {
            ++this.InnerClasses;
            this.RSol[this.InnerClasses - 1] = n;
            if (!bl) {
                this.SolStack = this.InnerClasses;
            }
        }

        void drawCard(Graphics graphics, boolean bl, int n) {
            if (n >= this.SolStack && bl) {
                this.max.paintCard(graphics, bl, this.getXPos(n), this.getYPos(n), this.RSol[n], this.paintCard);
            } else {
                this.max.paintCard(graphics, bl, this.getXPos(n), this.getYPos(n), 52, this.paintCard);
            }
        }

        public void drawStack(Graphics graphics) {
            if (this.isEmpty()) {
                this.drawCard(graphics, false, 0);
            } else {
                int n = 0;
                while (n < this.InnerClasses) {
                    this.drawCard(graphics, true, n);
                    ++n;
                }
            }
        }

        void drawTopCard(Graphics graphics) {
            if (this.isEmpty()) {
                this.drawCard(graphics, false, 0);
            } else {
                this.drawCard(graphics, true, this.InnerClasses - 1);
            }
        }

        public void eraseStack(Graphics graphics) {
            if (!this.isEmpty()) {
                int n = this.InnerClasses - 1;
                while (n >= 0) {
                    this.drawCard(graphics, false, n);
                    --n;
                }
            }
        }

        int getIthCard(int n) {
            return this.RSol[n];
        }

        int getNCards() {
            return this.InnerClasses;
        }

        int getOpenCards() {
            return this.InnerClasses - this.SolStack;
        }

        public int getPositionSelected(int n, int n2) {
            if (this.InnerClasses < 1) {
                if (this.paintCard != 0) {
                    return -1;
                }
                if (n < this.drawSelectionImage || n > this.drawSelectionImage + this.ConstantValue || n2 < this.A || n2 > this.A + this.I) {
                    return -1;
                }
                return -2;
            }
            if (this.InnerClasses == this.SolStack || this.paintCard != 2) {
                if (this.D(this.InnerClasses - 1, n, n2)) {
                    return this.InnerClasses - 1;
                }
            } else {
                int n3 = this.InnerClasses - 1;
                while (n3 >= this.SolStack) {
                    if (this.D(n3, n, n2)) {
                        return n3;
                    }
                    --n3;
                }
            }
            return -1;
        }

        int getType() {
            return this.paintCard;
        }

        public int getXPos(int n) {
            int n2 = this.drawSelectionImage;
            switch (this.paintCard) {
                case 0: {
                    n2 = this.drawSelectionImage + n / 8 * 2;
                    break;
                }
                case 3: {
                    if (n <= this.min) break;
                    n2 = this.drawSelectionImage + (n - this.min) * this.C;
                    break;
                }
            }
            return n2;
        }

        public int getYPos(int n) {
            int n2 = this.A;
            switch (this.paintCard) {
                case 0: {
                    n2 = this.A + n / 8 * 2;
                    break;
                }
                case 3: {
                    if (n <= this.min) break;
                    n2 = this.A + (n - this.min) * 2;
                    break;
                }
                case 2: {
                    if (this.InnerClasses < 1) {
                        return this.A;
                    }
                    if (this.SolStack == 0) {
                        return this.A + this.B * n;
                    }
                    if (n < this.SolStack) {
                        return this.A + n * 2;
                    }
                    n2 = this.A + this.SolStack * 2 + (n - this.SolStack) * this.B;
                    break;
                }
            }
            return n2;
        }

        private boolean D(int n, int n2, int n3) {
            int n4 = this.getXPos(n);
            int n5 = this.getYPos(n);
            return n2 >= n4 && n2 <= n4 + this.ConstantValue && n3 >= n5 && n3 <= n5 + this.I;
        }

        public boolean isEmpty() {
            return this.InnerClasses == 0;
        }

        public boolean isInside(int n, int n2) {
            int n3 = 3;
            if (this.paintCard == 2) {
                return n >= this.drawSelectionImage - 3 && n <= this.drawSelectionImage + this.ConstantValue + 3 && n2 >= this.A - 3;
            }
            if (this.paintCard == 1) {
                return n >= this.drawSelectionImage && n <= this.drawSelectionImage + this.ConstantValue && n2 >= this.A && n2 <= this.A + this.I;
            }
            return false;
        }

        boolean isTopCardClosed() {
            return this.InnerClasses <= this.SolStack;
        }

        int overlapArea(int n, int n2) {
            int n3 = Math.min(n + this.ConstantValue, this.drawSelectionImage + this.ConstantValue) - Math.max(n, this.drawSelectionImage);
            if (n3 < 0) {
                return -1;
            }
            int n4 = -1;
            if (this.paintCard == 2) {
                int n5 = n4 = n2 > this.A ? this.I : n2 + this.I - this.A;
            }
            if (this.paintCard == 1) {
                n4 = this.A + this.I - Math.max(n2, this.A);
            }
            return n4 < 0 ? -1 : n3 * n4;
        }

        void paintSelection(Graphics graphics, int n) {
            this.max.drawSelectionImage(graphics, this.getXPos(n), this.getYPos(n), this.ConstantValue, (this.InnerClasses - n - 1) * this.B + this.I);
        }

        void putCard(Graphics graphics, int n, boolean bl) {
            this.addCard(n, bl);
            this.drawTopCard(graphics);
        }

        int removeCard(Graphics graphics) {
            if (this.InnerClasses == 0) {
                return -1;
            }
            int n = this.RSol[this.InnerClasses - 1];
            this.drawCard(graphics, false, this.InnerClasses - 1);
            --this.InnerClasses;
            this.RSol[this.InnerClasses] = -1;
            if (this.SolStack > this.InnerClasses) {
                this.SolStack = this.InnerClasses;
            }
            this.drawTopCard(graphics);
            return n;
        }

        public void reset() {
            int n = 0;
            while (n < 25) {
                this.RSol[n] = -1;
                ++n;
            }
            this.SolStack = 0;
            this.InnerClasses = 0;
            this.min = 0;
        }

        public void setOffsets(Graphics graphics) {
            Dimension dimension = this.max.getSize();
            switch (this.paintCard) {
                case 0: {
                    this.A = 2;
                    this.drawSelectionImage = 10;
                    break;
                }
                case 3: {
                    this.A = 2;
                    this.drawSelectionImage = 10 + this.ConstantValue + 20;
                    break;
                }
                case 1: {
                    this.A = 2;
                    this.drawSelectionImage = dimension.width - 12 - (4 - (this.width - 7)) * (this.ConstantValue + 2);
                    break;
                }
                case 2: {
                    this.A = this.I + 9;
                    int n = (dimension.width - 20 - 7 * this.ConstantValue) / 6;
                    this.drawSelectionImage = 10 + this.width * (n + this.ConstantValue);
                    break;
                }
            }
        }

        public void setOpenIndex(int n) {
            this.min = this.InnerClasses - n;
        }

        public int topCard() {
            if (this.InnerClasses < 1) {
                return -1;
            }
            return this.RSol[this.InnerClasses - 1];
        }
    }
}

