/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class TrisTitleScreen
extends TrisScreen {
    private static final String IMAGE_FILE = "main1.jpg";
    private Font titleFont = new Font("TimesRoman", 1, 80);
    private Color titleColor = Color.white;
    private int titleHeight = 120;
    private Font authorFont = new Font("Arial", 1, 20);
    private Color authorColor = Color.blue;
    private int authorHeight = 160;
    private Font versionFont = new Font("Arial", 0, 12);
    private Color versionColor = Color.white;
    private BufferedImage image;
    private double imagePct = 10.0;
    private boolean clickMessageShown = false;
    private int timeCounter = 0;
    private int duration = 160;
    private int state;

    public TrisTitleScreen(TrisGameData trisGameData) {
        super(trisGameData);
        try {
            URL uRL = this.getClass().getResource(IMAGE_FILE);
            this.image = ImageIO.read(uRL);
        }
        catch (IOException iOException) {}
    }

    public void advance() {
        ++this.timeCounter;
        if (this.timeCounter % 15 == 0) {
            boolean bl = this.clickMessageShown = !this.clickMessageShown;
        }
        if (this.timeCounter >= this.duration) {
            this.timeCounter = 0;
            TrisScreenManager.setScreen(2);
        }
        this.imagePct *= 0.9;
        if (this.imagePct < 1.0) {
            this.imagePct = 1.0;
        }
    }

    public void render(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.titleFont);
        int n = fontMetrics.stringWidth("MO Techtris");
        graphics.setFont(this.titleFont);
        int n2 = 105;
        int n3 = 0;
        while (n2 < 255) {
            graphics.setColor(new Color(n2, n2, n2));
            graphics.drawString("MO Techtris", 320 - n / 2 + n3, this.titleHeight - n3);
            ++n3;
            n2 += 15;
        }
        fontMetrics = graphics.getFontMetrics(this.authorFont);
        n = fontMetrics.stringWidth("by Michael Henson");
        graphics.setFont(this.authorFont);
        graphics.setColor(this.authorColor);
        graphics.drawString("by Michael Henson", 320 - n / 2, this.authorHeight);
        fontMetrics = graphics.getFontMetrics(this.versionFont);
        graphics.setFont(this.versionFont);
        graphics.setColor(this.versionColor);
        n = fontMetrics.stringWidth("Missouri Tech Edition");
        graphics.drawString("Missouri Tech Edition", 0, 478);
        n = fontMetrics.stringWidth("Version 1.0 Beta 4");
        graphics.drawString("Version 1.0 Beta 4", 640 - n, 478);
        Font font = new Font("TimesRoman", 2, 10);
        String string = "Abandon hope all ye who enter here.";
        graphics.setFont(font);
        graphics.setColor(Color.lightGray);
        fontMetrics = graphics.getFontMetrics(font);
        n = fontMetrics.stringWidth(string);
        graphics.drawString(string, 320 - n / 2, 420);
        if (this.clickMessageShown) {
            graphics.setColor(Color.white);
            graphics.setFont(this.versionFont);
            fontMetrics = graphics.getFontMetrics(this.versionFont);
            string = "Press a key or";
            String string2 = "click to start game";
            n = fontMetrics.stringWidth(string);
            graphics.drawString(string, 320 - n / 2, 460);
            n = fontMetrics.stringWidth(string2);
            graphics.drawString(string2, 320 - n / 2, 475);
        }
        int n4 = (int)((double)this.image.getWidth() * this.imagePct);
        int n5 = (int)((double)this.image.getHeight() * this.imagePct);
        int n6 = 320 - n4 / 2;
        int n7 = 300 - n5 / 2;
        int n8 = 0;
        int n9 = 10;
        while (n9 > 0) {
            graphics.setColor(new Color(n8, n8, n8));
            graphics.fillRoundRect(n6 - n9, n7 - n9, n4 + n9 * 2, n5 + n9 * 2, n9, n9);
            n8 += 25;
            --n9;
        }
        graphics.drawImage(this.image, n6, n7, n4, n5, null);
    }
}

