/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferStrategy;

public class TrisScreenManager {
    private static final int NUM_SCREENS = 4;
    public static final int GAME_SCREEN = 0;
    public static final int TITLE_SCREEN = 1;
    public static final int HIGH_SCORES_SCREEN = 2;
    public static final int HELP_SCREEN = 3;
    private BufferStrategy bufferStrategy;
    private Rectangle bounds;
    private static TrisGameData gameData;
    private static TrisScreen currentScreen;

    public TrisScreenManager(TrisGameData trisGameData) {
        gameData = trisGameData;
        TrisScreenManager.setScreen(1);
    }

    public static void setScreen(int n) {
        switch (n) {
            case 1: {
                currentScreen = new TrisTitleScreen(gameData);
                break;
            }
            case 2: {
                currentScreen = new TrisHighScoresScreen(gameData);
                break;
            }
            case 0: {
                currentScreen = new TrisGameScreen(gameData);
                break;
            }
            case 3: {
                currentScreen = new TrisHelpScreen(gameData);
                break;
            }
        }
        currentScreen.load();
    }

    public void advance() {
        currentScreen.advance();
    }

    public void render() {
        BufferStrategy bufferStrategy = MHDisplayModeChooser.getBufferStrategy();
        Graphics graphics = bufferStrategy.getDrawGraphics();
        Rectangle rectangle = MHDisplayModeChooser.getScreenBounds();
        if (bufferStrategy.contentsLost()) {
            return;
        }
        currentScreen.render(graphics);
        bufferStrategy.show();
        graphics.dispose();
    }

    public void keyTyped(KeyEvent keyEvent) {
        currentScreen.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        currentScreen.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        currentScreen.keyReleased(keyEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        currentScreen.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        currentScreen.mouseReleased(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        currentScreen.mouseClicked(mouseEvent);
    }
}

