/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class TrisScoringPanel
extends TrisInfoPanel {
    public static final int TOP = 8;
    public static final int LEFT = 24;
    private static final int WIDTH = 7;
    private static final int HEIGHT = 15;
    private static final int NUM_VARIABLES = 4;
    private static final String SCORE_LABEL = "Score";
    private static final String LINES_LABEL = "Lines";
    private static final String PIECES_LABEL = "Pieces";
    private static final String LEVEL_LABEL = "Level";
    private static final int LABEL_SPACING = 50;
    private static final int VALUE_SPACING = 25;
    private static final Color LABEL_COLOR = Color.green;
    private static final Color VALUE_COLOR = Color.white;
    private TrisGameData gameData;
    private String[] labels;
    private int[] values;

    public TrisScoringPanel(TrisGameData trisGameData) {
        this.gameData = trisGameData;
        this.labels = new String[4];
        this.values = new int[4];
        this.labels[0] = SCORE_LABEL;
        this.labels[1] = LINES_LABEL;
        this.labels[2] = PIECES_LABEL;
        this.labels[3] = LEVEL_LABEL;
        this.setSize(7, 15);
        this.setLocation(24, 8);
    }

    public void advance() {
        this.values[0] = this.gameData.getScore();
        this.values[1] = this.gameData.getLineCount();
        this.values[2] = this.gameData.getPieceCount();
        this.values[3] = this.gameData.getLevel();
    }

    public void render(Graphics graphics) {
        int n = 480;
        int n2 = 160;
        int n3 = 140;
        int n4 = 300;
        graphics.setColor(Color.black);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(TrisGameScreen.BACKGROUND_COLOR);
        graphics.draw3DRect(n, n2, n3, n4, false);
        int n5 = n2 + 30;
        int n6 = 0;
        while (n6 < 4) {
            graphics.setColor(LABEL_COLOR);
            this.centerText(graphics, this.labels[n6], TrisInfoPanel.TEXT_FONT, n5);
            graphics.setColor(VALUE_COLOR);
            this.centerText(graphics, Integer.toString(this.values[n6]), TrisInfoPanel.NUMBER_FONT, n5 += 25);
            n5 += 50;
            ++n6;
        }
    }
}

