/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class TrisHighScoresScreen
extends TrisScreen {
    private Font titleFont = new Font("TimesRoman", 1, 60);
    private Font indexFont = new Font("Arial", 1, 16);
    private Color indexColor = Color.white;
    private Font nameFont = new Font("Arial", 1, 18);
    private Color nameColor = Color.blue;
    private Font scoreFont = new Font("Monospaced", 1, 18);
    private Color scoreColor = Color.yellow;
    private BufferedImage backgroundRect;
    private int spacing = 26;
    private int top = 160;
    private int indexRight = 150;
    private int nameLeft = 170;
    private int scoreRight = 500;
    private int timeCounter;
    private int duration = 700;
    private boolean clickMessageShown = false;

    public TrisHighScoresScreen(TrisGameData trisGameData) {
        super(trisGameData);
    }

    public void advance() {
        ++this.timeCounter;
        if (this.timeCounter % 15 == 0) {
            boolean bl = this.clickMessageShown = !this.clickMessageShown;
        }
        if (this.timeCounter >= this.duration) {
            this.timeCounter = 0;
            TrisScreenManager.setScreen(3);
        }
    }

    public void render(Graphics graphics) {
        this.drawBackgroundRect(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.titleFont);
        int n = fontMetrics.stringWidth("High Scores");
        graphics.setFont(this.titleFont);
        int n2 = fontMetrics.getHeight();
        int n3 = 105;
        int n4 = 0;
        while (n3 < 255) {
            graphics.setColor(new Color(n3, n3, n3));
            graphics.drawString("High Scores", 320 - n / 2 + n4, n2 - n4);
            ++n4;
            n3 += 15;
        }
        int n5 = this.timeCounter / 20;
        if (n5 >= 10) {
            n5 = 9;
        }
        int n6 = 9;
        while (n6 >= 9 - n5) {
            graphics.setFont(this.indexFont);
            graphics.setColor(this.indexColor);
            fontMetrics = graphics.getFontMetrics(this.indexFont);
            n = fontMetrics.stringWidth(n6 + 1 + ".");
            graphics.drawString(n6 + 1 + ".", this.indexRight - n, this.top + n6 * this.spacing);
            graphics.setFont(this.nameFont);
            graphics.setColor(this.nameColor);
            graphics.drawString(this.gameData.getHighScoresList().getRecord((int)n6).name, this.nameLeft, this.top + n6 * this.spacing);
            graphics.setFont(this.scoreFont);
            graphics.setColor(this.scoreColor);
            fontMetrics = graphics.getFontMetrics(this.scoreFont);
            n = fontMetrics.stringWidth(this.gameData.getHighScoresList().getRecord((int)n6).score + "");
            graphics.drawString(this.gameData.getHighScoresList().getRecord((int)n6).score + "", this.scoreRight - n, this.top + n6 * this.spacing);
            --n6;
        }
        String string = "MO Techtris v.1.0 Beta 4";
        Font font = new Font("Arial", 0, 12);
        Color color = Color.white;
        fontMetrics = graphics.getFontMetrics(font);
        n = fontMetrics.stringWidth(string);
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(string, 635 - n, 475);
        if (this.clickMessageShown) {
            graphics.setColor(Color.white);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            String string2 = "Press a key or";
            String string3 = "click to start game";
            n = fontMetrics.stringWidth(string2);
            graphics.drawString(string2, 320 - n / 2, 460);
            n = fontMetrics.stringWidth(string3);
            graphics.drawString(string3, 320 - n / 2, 475);
        }
    }

    private void drawBackgroundRect(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        if (this.backgroundRect != null) {
            graphics.drawImage(this.backgroundRect, n, n2, n3, n4, null);
            return;
        }
        this.backgroundRect = new BufferedImage(n3, n4, 1);
        Graphics graphics2 = this.backgroundRect.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, n3, n4);
        int n5 = 0;
        while (n5 < 80) {
            graphics2.setColor(new Color(80 - n5, 80 - n5, 80 - n5));
            graphics2.fillRect(n5, n5, n3 - n5 * 2, n4 - n5 * 2);
            ++n5;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
    }
}

