/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;

public class TrisHighScoresList {
    public static final int MAX_SCORES = 10;
    private static final String FILE_NAME = "HISCORES.DAT";
    private TrisHighScoreRecord[] highList = new TrisHighScoreRecord[10];
    private ObjectOutputStream output;
    private ObjectInputStream input;

    public TrisHighScoresList() {
        this.readScoresFile();
    }

    public TrisHighScoreRecord getRecord(int n) {
        return this.highList[n];
    }

    public boolean addToList(String string, int n) {
        boolean bl = false;
        this.sort();
        if (this.highList[this.highList.length - 1].score >= n) {
            bl = false;
        } else {
            this.highList[this.highList.length - 1].name = string;
            this.highList[this.highList.length - 1].score = n;
            this.sort();
            this.saveScoresFile();
            bl = true;
        }
        return bl;
    }

    private void readScoresFile() {
        int n = 0;
        while (n < this.highList.length) {
            this.highList[n] = new TrisHighScoreRecord();
            ++n;
        }
        try {
            this.input = new ObjectInputStream(new FileInputStream(FILE_NAME));
            if (this.input != null) {
                int n2 = 0;
                while (n2 < this.highList.length) {
                    try {
                        this.highList[n2] = (TrisHighScoreRecord)this.input.readObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    ++n2;
                }
                this.input.close();
            }
            this.sort();
        }
        catch (IOException iOException) {
            System.out.println("ERROR:  Cannot open HISCORES.DAT for reading.");
        }
    }

    public int getLowScore() {
        return this.highList[this.highList.length - 1].score;
    }

    public void print() {
        int n = 0;
        while (n < this.highList.length) {
            System.out.print(this.highList[n].name);
            System.out.println("\t" + this.highList[n].score);
            ++n;
        }
    }

    private void sort() {
        int n = this.highList.length;
        while (n > 0) {
            int n2 = this.highList.length - 1;
            while (n2 > 0) {
                if (this.highList[n2].score > this.highList[n2 - 1].score) {
                    this.swap(this.highList, n2, n2 - 1);
                }
                --n2;
            }
            --n;
        }
    }

    private void swap(TrisHighScoreRecord[] trisHighScoreRecordArray, int n, int n2) {
        TrisHighScoreRecord trisHighScoreRecord = trisHighScoreRecordArray[n];
        trisHighScoreRecordArray[n] = trisHighScoreRecordArray[n2];
        trisHighScoreRecordArray[n2] = trisHighScoreRecord;
    }

    private void saveScoresFile() {
        try {
            this.output = new ObjectOutputStream(new FileOutputStream(FILE_NAME));
            int n = 0;
            while (n < 10) {
                this.output.writeObject(this.highList[n]);
                ++n;
            }
            this.output.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR:  Cannot save HISCORES.DAT");
            JOptionPane.showMessageDialog(null, "ERROR:  Cannot save HISCORES.DAT", "I/O Exception", 0);
        }
    }

    public static void main(String[] stringArray) {
        TrisHighScoresList trisHighScoresList = new TrisHighScoresList();
        trisHighScoresList.print();
    }
}

