/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class TrisHelpScreen
extends TrisScreen {
    private Font titleFont = new Font("TimesRoman", 1, 60);
    private Font labelFont = new Font("Arial", 1, 26);
    private Color labelColor = Color.blue;
    private Font controlFont = new Font("Monospaced", 1, 26);
    private Color controlColor = Color.green;
    private BufferedImage backgroundRect;
    int spacing = 40;
    int top = 150;
    int actionRight = 300;
    int keyControlLeft = 340;
    int timeCounter;
    int duration = 600;
    private boolean clickMessageShown = false;

    public TrisHelpScreen(TrisGameData trisGameData) {
        super(trisGameData);
    }

    public void advance() {
        ++this.timeCounter;
        if (this.timeCounter % 15 == 0) {
            boolean bl = this.clickMessageShown = !this.clickMessageShown;
        }
        if (this.timeCounter >= this.duration) {
            this.timeCounter = 0;
            TrisScreenManager.setScreen(1);
        }
    }

    public void render(Graphics graphics) {
        int n;
        this.drawBackgroundRect(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.titleFont);
        int n2 = fontMetrics.stringWidth("Controls");
        graphics.setFont(this.titleFont);
        int n3 = fontMetrics.getHeight();
        int n4 = 105;
        int n5 = 0;
        while (n4 < 255) {
            graphics.setColor(new Color(n4, n4, n4));
            graphics.drawString("Controls", 320 - n2 / 2 + n5, n3 - n5);
            ++n5;
            n4 += 15;
        }
        int n6 = this.top;
        if (this.timeCounter > 0) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Move Right");
            n = this.actionRight - n2;
            graphics.drawString("Move Right", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(39), n, n6);
            n6 += this.spacing;
        }
        if (this.timeCounter > 30) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Move Left");
            n = this.actionRight - n2;
            graphics.drawString("Move Left", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(37), n, n6);
            n6 += this.spacing;
        }
        if (this.timeCounter > 60) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Rotate");
            n = this.actionRight - n2;
            graphics.drawString("Rotate", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(38), n, n6);
            n6 += this.spacing;
        }
        if (this.timeCounter > 90) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Speed Drop");
            n = this.actionRight - n2;
            graphics.drawString("Speed Drop", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(40), n, n6);
            n6 += this.spacing;
        }
        if (this.timeCounter > 120) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Pause Game");
            n = this.actionRight - n2;
            graphics.drawString("Pause Game", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(80), n, n6);
            n6 += this.spacing;
        }
        if (this.timeCounter > 150) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Toggle Grid");
            n = this.actionRight - n2;
            graphics.drawString("Toggle Grid", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(71), n, n6);
            n6 += this.spacing;
        }
        if (this.timeCounter > 180) {
            graphics.setFont(this.labelFont);
            graphics.setColor(this.labelColor);
            fontMetrics = graphics.getFontMetrics(this.labelFont);
            n2 = fontMetrics.stringWidth("Quit");
            n = this.actionRight - n2;
            graphics.drawString("Quit", n, n6);
            graphics.setFont(this.controlFont);
            graphics.setColor(this.controlColor);
            n = this.keyControlLeft;
            graphics.drawString(KeyEvent.getKeyText(27), n, n6);
            n6 += this.spacing;
        }
        String string = "MO Techtris v.1.0 Beta 4";
        Font font = new Font("Arial", 0, 12);
        Color color = Color.white;
        fontMetrics = graphics.getFontMetrics(font);
        n2 = fontMetrics.stringWidth(string);
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(string, 635 - n2, 475);
        if (this.clickMessageShown) {
            graphics.setColor(Color.white);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics(font);
            String string2 = "Press a key or";
            String string3 = "click to start game";
            n2 = fontMetrics.stringWidth(string2);
            graphics.drawString(string2, 320 - n2 / 2, 460);
            n2 = fontMetrics.stringWidth(string3);
            graphics.drawString(string3, 320 - n2 / 2, 475);
        }
    }

    private void drawBackgroundRect(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        if (this.backgroundRect != null) {
            graphics.drawImage(this.backgroundRect, n, n2, n3, n4, null);
            return;
        }
        this.backgroundRect = new BufferedImage(n3, n4, 1);
        Graphics graphics2 = this.backgroundRect.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, n3, n4);
        int n5 = 0;
        while (n5 < 80) {
            graphics2.setColor(new Color(80 - n5, 80 - n5, 80 - n5));
            graphics2.fillRect(n5, n5, n3 - n5 * 2, n4 - n5 * 2);
            ++n5;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
    }
}

