/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;

public class TrisGameScreen
extends TrisScreen {
    public static final Color BACKGROUND_COLOR = Color.lightGray;
    private static final int STATE_PLAYING = 0;
    private static final int STATE_PAUSED = 1;
    private static final int STATE_READY = 2;
    private static final int STATE_GAME_ENDING = 3;
    private static final int STATE_GAME_OVER = 4;
    private static final int GAMEBOARD_PANEL = 1;
    private int state;
    private long readyStartTime = 0L;
    private long readyStateDelay = 3000L;
    private static final int NUM_PANELS = 4;
    private TrisInfoPanel[] panels;
    private boolean gameOverShown = true;
    private static final long gameOverDelay = 500L;
    private long gameOverLastToggle = System.currentTimeMillis();

    public TrisGameScreen(TrisGameData trisGameData) {
        super(trisGameData);
        this.panels = new TrisInfoPanel[4];
        this.panels[0] = new TrisStatisticsPanel(this.gameData);
        this.panels[1] = new TrisGameBoardPanel(this.gameData);
        this.panels[2] = new TrisPreviewPanel(this.gameData);
        this.panels[3] = new TrisScoringPanel(this.gameData);
        this.setState(2);
    }

    public void load() {
        this.gameData.resetGame();
    }

    private void setState(int n) {
        this.state = n;
        if (this.state == 2) {
            this.readyStartTime = System.currentTimeMillis();
        }
    }

    public void advance() {
        switch (this.state) {
            case 2: {
                if (System.currentTimeMillis() - this.readyStartTime <= this.readyStateDelay) break;
                this.setState(0);
                break;
            }
            case 0: {
                this.updatePanels();
                if (!((TrisGameBoardPanel)this.panels[1]).isGameOver()) break;
                this.setState(3);
                break;
            }
            case 3: {
                if (((TrisGameBoardPanel)this.panels[1]).isBoardFull()) {
                    this.setState(4);
                }
                ((TrisGameBoardPanel)this.panels[1]).randomFill();
                break;
            }
            case 4: {
                if (this.gameData.getScore() > this.gameData.getLowScore()) {
                    JOptionPane jOptionPane = new JOptionPane();
                    String string = JOptionPane.showInputDialog(MHDisplayModeChooser.getCanvas(), "Congratulations!  You got a high score!\n\nPlease enter your name.", "High Score", -1);
                    if (string == null) {
                        string = " ";
                    }
                    this.gameData.addHighScore(string, this.gameData.getScore());
                }
                TrisScreen.lastKeyPressTime = System.currentTimeMillis();
                TrisScreenManager.setScreen(2);
            }
        }
    }

    public void render(Graphics graphics) {
        switch (this.state) {
            case 2: {
                this.drawGameScreen(graphics);
                Font font = new Font("Monospaced", 3, 50);
                graphics.setFont(font);
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                int n = fontMetrics.stringWidth("Get ready!");
                graphics.setColor(Color.black);
                graphics.drawString("Get ready!", 346 - n / 2, 246);
                graphics.setColor(Color.white);
                graphics.drawString("Get ready!", 340 - n / 2, 230);
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this.drawGameScreen(graphics);
                break;
            }
            case 3: {
                this.drawGameScreen(graphics);
                if (System.currentTimeMillis() - this.gameOverLastToggle >= 500L) {
                    this.gameOverLastToggle = System.currentTimeMillis();
                    boolean bl = this.gameOverShown = !this.gameOverShown;
                }
                if (!this.gameOverShown) break;
                Font font = new Font("Monospaced", 3, 48);
                graphics.setFont(font);
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                int n = fontMetrics.stringWidth("Game Over");
                graphics.setColor(Color.black);
                graphics.drawString("Game Over", 346 - n / 2, 246);
                graphics.setColor(Color.white);
                graphics.drawString("Game Over", 340 - n / 2, 230);
            }
        }
    }

    private void drawGameScreen(Graphics graphics) {
        Rectangle rectangle = MHDisplayModeChooser.getScreenBounds();
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fill3DRect(0, 0, rectangle.width, rectangle.height, true);
        int n = 0;
        while (n < 4) {
            if (this.panels[n] != null) {
                this.panels[n].render(graphics);
            }
            ++n;
        }
        TrisGameData.rowFlasher.render(graphics);
    }

    private void updatePanels() {
        int n = 0;
        while (n < 4) {
            if (this.panels[n] != null) {
                this.panels[n].advance();
            }
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 80: {
                if (this.state != 0) break;
                ((TrisGameBoardPanel)this.panels[1]).keyPressed(keyEvent);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.setState(4);
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 71: 
            case 80: {
                if (this.state != 0) break;
                ((TrisGameBoardPanel)this.panels[1]).keyReleased(keyEvent);
            }
        }
    }
}

