/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public abstract class TrisGamePiece
extends TrisGameObject {
    public static final int NUM_PIECE_TYPES = 7;
    protected static final int STATE_WAITING = 0;
    protected static final int STATE_FALLING = 1;
    protected static final int STATE_LANDING = 2;
    protected static final long DEFAULT_FALL_DELAY = 1000L;
    protected static final long MOVE_DELAY = 80L;
    protected static final long ROTATION_DELAY = 200L;
    public static int PIECE_COUNT = -1;
    protected TrisGridSpace[][] grid;
    protected static int topRow;
    protected static int leftColumn;
    private int size = 4;
    protected static int orientation;
    private Color color;
    private TrisGameBoard gameBoard;
    protected int state;
    protected boolean movingRight = false;
    protected boolean movingLeft = false;
    protected boolean dropping = false;
    protected boolean rotating = false;
    private long lastRotationTime;
    private long lastMoveTime;
    private long lastFallTime;
    private static long fallDelay;

    public TrisGamePiece(TrisGameBoard trisGameBoard) {
        this.gameBoard = trisGameBoard;
        this.chooseColor();
        this.initialize();
    }

    public static void speedUpFall(int n) {
        fallDelay = (long)((double)fallDelay - (double)fallDelay * ((double)n * 0.075));
    }

    public static void resetFallDelay() {
        fallDelay = 1000L;
    }

    public void initialize() {
        topRow = -2;
        int n = 17;
        leftColumn = n - this.getSize() / 2;
        this.grid = new TrisGridSpace[this.size][this.size];
        orientation = 0;
        this.lastFallTime = System.currentTimeMillis();
        this.state = 0;
        this.setupGrid();
    }

    public void setLocation(int n, int n2) {
        topRow = n;
        leftColumn = n2;
    }

    public void setState(int n) {
        this.state = n;
        if (1 == n) {
            ++PIECE_COUNT;
        }
    }

    public void render(Graphics graphics) {
        int n = topRow * 20;
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = leftColumn * 20;
            int n4 = 0;
            while (n4 < this.size) {
                if (this.grid[n2][n4].isOccupied() && (this.gameBoard.isInBounds(topRow + n2 - 2, leftColumn + n4 - 12) || this.state == 0)) {
                    graphics.setColor(this.color);
                    graphics.fill3DRect(n3, n, 19, 19, true);
                }
                n3 += 20;
                ++n4;
            }
            n += 20;
            ++n2;
        }
    }

    public void drawStaticImage(Graphics graphics, int n, int n2) {
        int n3 = topRow;
        int n4 = leftColumn;
        int n5 = orientation;
        orientation = 0;
        this.setupGrid();
        int n6 = 0;
        while (n6 < 4) {
            int n7 = 0;
            while (n7 < 4) {
                if (this.grid[n6][n7].isOccupied()) {
                    graphics.setColor(this.color);
                    graphics.fill3DRect((n2 + n7) * 20, (n + n6) * 20, 19, 19, true);
                }
                ++n7;
            }
            ++n6;
        }
        topRow = n3;
        leftColumn = n4;
        orientation = n5;
    }

    public void advance() {
        switch (this.state) {
            case 1: {
                if (this.movingRight) {
                    this.moveRight();
                }
                if (this.movingLeft) {
                    this.moveLeft();
                }
                if (this.dropping) {
                    this.drop();
                }
                if (this.rotating) {
                    this.rotate();
                }
                long l = System.currentTimeMillis();
                if (this.canFall()) {
                    if (l - this.lastFallTime < fallDelay) break;
                    ++topRow;
                    this.lastFallTime = l;
                    break;
                }
                this.gameBoard.addToBoard(this, topRow, leftColumn);
                this.gameBoard.checkRows();
                this.gameBoard.checkGameOver();
                this.state = 2;
            }
        }
    }

    public void moveRight() {
        long l = System.currentTimeMillis();
        if (l - this.lastMoveTime < 80L) {
            return;
        }
        if (this.canMoveTo(topRow, leftColumn + 1)) {
            ++leftColumn;
            this.lastMoveTime = System.currentTimeMillis();
        }
    }

    public void moveLeft() {
        long l = System.currentTimeMillis();
        if (l - this.lastMoveTime < 80L) {
            return;
        }
        if (this.canMoveTo(topRow, leftColumn - 1)) {
            --leftColumn;
            this.lastMoveTime = System.currentTimeMillis();
        }
    }

    public void rotate() {
        long l = System.currentTimeMillis();
        if (l - this.lastRotationTime < 200L) {
            return;
        }
        int n = orientation++;
        if (orientation > 3) {
            orientation = 0;
        }
        this.setupGrid();
        if (!this.canMoveTo(topRow, leftColumn)) {
            orientation = n;
            this.setupGrid();
        }
        this.lastRotationTime = System.currentTimeMillis();
    }

    public void drop() {
        int n = 0;
        int n2 = 1;
        n = 0;
        while (n < n2) {
            if (this.canFall()) {
                ++topRow;
            }
            ++n;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getState() {
        return this.state;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isOccupied(int n, int n2) {
        boolean bl = false;
        try {
            bl = this.grid[n][n2].isOccupied();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("EXCEPTION:  TrisGamePiece.isOccupied() -- Array index out of bounds");
            System.err.println("\tPiece grid space:  " + n + ", " + n2);
            System.err.println("\tException message:  " + arrayIndexOutOfBoundsException.getMessage());
            System.err.println("\tStack trace:");
            arrayIndexOutOfBoundsException.printStackTrace();
            System.exit(1);
        }
        return bl;
    }

    public abstract void setupGrid();

    protected void fillWithPattern(boolean[][] blArray) {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                try {
                    this.grid[n][n2] = new TrisGridSpace();
                    this.grid[n][n2].setOccupied(blArray[n][n2]);
                    this.grid[n][n2].setColor(this.color);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println("EXCEPTION:  TrisGamePiece.fillWithPattern() -- Array index out of bounds");
                    System.err.println("\tPiece grid space:  " + n + ", " + n2);
                    System.err.println("\tException message:  " + arrayIndexOutOfBoundsException.getMessage());
                    System.err.println("\tStack trace:  \n");
                    arrayIndexOutOfBoundsException.printStackTrace();
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void blankOutPattern(boolean[][] blArray) {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                blArray[n][n2] = false;
                ++n2;
            }
            ++n;
        }
    }

    protected void chooseColor() {
        int n = 50 + (int)(Math.random() * 200.0);
        int n2 = 50 + (int)(Math.random() * 200.0);
        int n3 = 50 + (int)(Math.random() * 200.0);
        this.color = new Color(n, n2, n3);
    }

    private boolean canFall() {
        boolean bl = true;
        if (topRow <= 0) {
            bl = true;
        } else {
            int n = 0;
            while (n < this.size) {
                int n2 = 0;
                while (n2 < this.size) {
                    if (this.isOccupied(n, n2) && this.gameBoard.isOccupied(topRow + n + 1 - 2, leftColumn + n2 - 12)) {
                        bl = false;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean canMoveTo(int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        while (n3 < this.size) {
            int n4 = 0;
            while (n4 < this.size) {
                if (this.isOccupied(n3, n4) && this.gameBoard.isOccupied(n + n3 - 2, n2 + n4 - 12)) {
                    bl = false;
                }
                ++n4;
            }
            ++n3;
        }
        return bl;
    }

    public abstract int getPieceNumber();

    static {
        fallDelay = 1000L;
    }
}

