/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class TrisGameData {
    public static final String AUTHOR_NAME = "Michael Henson";
    public static final String GAME_NAME = "MO Techtris";
    public static final String VERSION = "1.0 Beta 4";
    public static final String EDITION = "Missouri Tech";
    public static final long ANIMATION_DELAY = 30L;
    public static final long LANDING_DELAY_MULTIPLIER = 3L;
    private static final int SCORE_EVENT_ONE_LINE = 1;
    private static final int SCORE_EVENT_TWO_LINES = 2;
    private static final int SCORE_EVENT_THREE_LINES = 3;
    private static final int SCORE_EVENT_FOUR_LINES = 4;
    public static final int SCORE_EVENT_PIECE_LANDED = 5;
    public static final int SCORE_VALUE_PIECE_LANDED = 1;
    public static final int SCORE_VALUE_ONE_LINE = 100;
    public static final int SCORE_VALUE_TWO_LINES = 150;
    public static final int SCORE_VALUE_THREE_LINES = 250;
    public static final int SCORE_VALUE_FOUR_LINES = 500;
    public static TrisRowFlasher rowFlasher = new TrisRowFlasher();
    private static TrisHighScoresList highScores;
    private int score = -1;
    private int numLinesCleared;
    private int numPiecesDropped;
    private int level = 1;
    private static TrisGameBoard gameBoard;
    private static TrisGamePiece nextPiece;
    private static TrisStatisticsData stats;
    private boolean programOver;
    private boolean gameOver;
    private int levelMultiplier;

    public TrisGameData() {
        highScores = new TrisHighScoresList();
        this.resetGame();
    }

    public void resetGame() {
        gameBoard = new TrisGameBoard(this);
        stats = new TrisStatisticsData();
        this.score = 0;
        this.numLinesCleared = 0;
        TrisGamePiece.PIECE_COUNT = 0;
        this.numPiecesDropped = 0;
        this.level = 1;
        TrisGamePiece.resetFallDelay();
    }

    public TrisHighScoresList getHighScoresList() {
        return highScores;
    }

    public void setGameOver(boolean bl) {
        this.gameOver = bl;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void setProgramOver(boolean bl) {
        this.programOver = bl;
    }

    public boolean isProgramOver() {
        return this.programOver;
    }

    public void removeRows() {
        gameBoard.removeRows();
    }

    public TrisGameBoard getGameBoard() {
        return gameBoard;
    }

    public int getLowScore() {
        return highScores.getLowScore();
    }

    public void addHighScore(String string, int n) {
        highScores.addToList(string, n);
    }

    public int getScore() {
        return this.score;
    }

    public int getPieceCount() {
        this.numPiecesDropped = TrisGamePiece.PIECE_COUNT;
        return this.numPiecesDropped;
    }

    public int getPieceStats(int n) {
        return stats.getCount(n);
    }

    public void incrementPieceStats(int n) {
        stats.increment(n);
    }

    public void drawStaticPieceImage(int n, Graphics graphics, int n2, int n3) {
        stats.drawStaticImage(n, graphics, n2, n3);
    }

    public int getLineCount() {
        return this.numLinesCleared;
    }

    public void incrementLineCount() {
        ++this.numLinesCleared;
        if (this.numLinesCleared % 10 == 0) {
            this.nextLevel();
            TrisGamePiece.speedUpFall(this.level);
        }
    }

    public int getLevel() {
        return this.level;
    }

    private void nextLevel() {
        ++this.level;
    }

    public void scoreEvent(int n) {
        switch (n) {
            case 5: {
                ++this.score;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.levelMultiplier = (int)((float)this.level * 1.5f);
                this.score += this.getLineValue(n) * n * this.levelMultiplier;
            }
        }
    }

    private int getLineValue(int n) {
        switch (n) {
            case 1: {
                return 100;
            }
            case 2: {
                return 150;
            }
            case 3: {
                return 250;
            }
            case 4: {
                return 500;
            }
        }
        return 0;
    }

    public TrisGamePiece choosePiece() {
        int n = (int)(Math.random() * 7.0);
        switch (n) {
            case 0: {
                return new TrisGamePieceType0(gameBoard);
            }
            case 1: {
                return new TrisGamePieceType1(gameBoard);
            }
            case 2: {
                return new TrisGamePieceType2(gameBoard);
            }
            case 3: {
                return new TrisGamePieceType3(gameBoard);
            }
            case 4: {
                return new TrisGamePieceType4(gameBoard);
            }
            case 5: {
                return new TrisGamePieceType5(gameBoard);
            }
            case 6: {
                return new TrisGamePieceType6(gameBoard);
            }
        }
        return null;
    }

    public void chooseNextPiece() {
        nextPiece = this.choosePiece();
    }

    public TrisGamePiece getNextPiece() {
        if (nextPiece == null) {
            this.chooseNextPiece();
        }
        return nextPiece;
    }
}

