/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;

public class TrisGameBoardPanel
extends TrisInfoPanel {
    public static final int TOP = 2;
    public static final int LEFT = 12;
    private static final int WIDTH = 10;
    private static final int HEIGHT = 20;
    private TrisGameBoard gameBoard;
    private TrisGamePiece gamePiece;
    private TrisGameData gameData;
    private BufferedImage backgroundRect;
    private static long PAUSE_KEY_DELAY = 1000L;
    private boolean paused = false;
    private long lastPauseKeyTime = System.currentTimeMillis();
    private int pausedHeight = -50;
    private int pausedSpeed = 1;
    private boolean pauseMessageOn = true;

    public TrisGameBoardPanel(TrisGameData trisGameData) {
        this.gameData = trisGameData;
        this.gameBoard = this.gameData.getGameBoard();
        this.gamePiece = this.gameData.choosePiece();
        this.gamePiece.initialize();
        this.gamePiece.setState(1);
        this.gameData.chooseNextPiece();
        this.setLocation(2, 12);
        this.setSize(10, 20);
    }

    public void advance() {
        if (this.paused) {
            return;
        }
        if (TrisGameData.rowFlasher.isFlashing()) {
            TrisGameData.rowFlasher.advance();
            if (!TrisGameData.rowFlasher.isFlashing()) {
                this.gameData.removeRows();
            }
            return;
        }
        if (this.gamePiece.getState() == 2) {
            try {
                Thread.sleep(90L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.gamePiece = this.gameData.getNextPiece();
            this.gameData.incrementPieceStats(this.gamePiece.getPieceNumber());
            this.gamePiece.initialize();
            this.gamePiece.setState(1);
            this.gameData.chooseNextPiece();
        }
        this.gamePiece.advance();
    }

    public boolean isGameOver() {
        return this.gameBoard.checkGameOver();
    }

    public void randomFill() {
        this.gameBoard.randomFill();
    }

    public boolean isBoardFull() {
        return this.gameBoard.isBoardFull();
    }

    public void pauseGame(boolean bl) {
        if (System.currentTimeMillis() - this.lastPauseKeyTime <= PAUSE_KEY_DELAY) {
            return;
        }
        this.paused = bl;
        this.lastPauseKeyTime = System.currentTimeMillis();
        if (this.paused) {
            this.pausedHeight = 60;
            this.pausedSpeed = 1;
        }
    }

    public void render(Graphics graphics) {
        this.drawBackgroundRect(graphics);
        if (this.paused) {
            this.drawPausedScreen(graphics);
            return;
        }
        this.gameBoard.render(graphics);
        if (!this.isGameOver()) {
            this.gamePiece.render(graphics);
        }
    }

    private void drawPausedScreen(Graphics graphics) {
        Font font = new Font("Monospaced", 1, 40);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.stringWidth("Paused");
        graphics.setColor(TrisGameScreen.BACKGROUND_COLOR);
        graphics.drawString("Paused", 340 - n / 2, this.pausedHeight);
        ++this.pausedSpeed;
        this.pausedHeight += this.pausedSpeed;
        if (this.pausedHeight > 440) {
            this.pausedHeight = 440;
            this.pausedSpeed *= -1;
        }
    }

    private void drawBackgroundRect(Graphics graphics) {
        int n = 220;
        int n2 = 20;
        int n3 = 240;
        int n4 = 440;
        if (this.backgroundRect != null) {
            graphics.drawImage(this.backgroundRect, n, n2, n3, n4, null);
            return;
        }
        this.backgroundRect = new BufferedImage(n3, n4, 1);
        Graphics graphics2 = this.backgroundRect.getGraphics();
        graphics2.setColor(TrisGameScreen.BACKGROUND_COLOR);
        graphics2.fillRect(0, 0, n3, n4);
        int n5 = 0;
        while (n5 < 20) {
            graphics2.setColor(new Color(0, 0, n5 * 10 + 50));
            graphics2.fillRoundRect(n5, n5, n3 - n5 * 2, n4 - n5 * 2, 40 - n5, 40 - n5);
            ++n5;
        }
        graphics2.setColor(Color.black);
        graphics2.fillRect(20, 20, n3 - 40, n4 - 40);
        graphics2.setColor(new Color(0, 0, 255));
        graphics2.draw3DRect(n + 20, n2 + 20, n3 - 40, n4 - 40, false);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.gamePiece.rotating = true;
                break;
            }
            case 39: {
                this.gamePiece.movingRight = true;
                break;
            }
            case 37: {
                this.gamePiece.movingLeft = true;
                break;
            }
            case 40: {
                this.gamePiece.dropping = true;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.gamePiece.rotating = false;
                break;
            }
            case 39: {
                this.gamePiece.movingRight = false;
                break;
            }
            case 37: {
                this.gamePiece.movingLeft = false;
                break;
            }
            case 40: {
                this.gamePiece.dropping = false;
                break;
            }
            case 80: {
                this.pauseGame(!this.paused);
                break;
            }
            case 71: {
                this.gameBoard.toggleGrid();
            }
        }
    }
}

