/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class TrisGameBoard
extends TrisGameObject {
    public static final int BOARD_WIDTH = 10;
    public static final int BOARD_HEIGHT = 20;
    private static TrisGridSpace[][] board;
    private TrisGameData gameData;
    private boolean[] rowFlags = new boolean[20];
    private boolean boardFull = false;
    private boolean gridOn = false;

    public TrisGameBoard(TrisGameData trisGameData) {
        this.gameData = trisGameData;
        board = new TrisGridSpace[20][10];
        int n = 0;
        while (n < 20) {
            int n2 = 0;
            while (n2 < 10) {
                TrisGameBoard.board[n][n2] = new TrisGridSpace();
                board[n][n2].setOccupied(false);
                ++n2;
            }
            this.rowFlags[n] = false;
            ++n;
        }
    }

    public void advance() {
    }

    public boolean checkGameOver() {
        boolean bl = false;
        int n = 0;
        while (n < 10) {
            if (board[0][n].isOccupied()) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void randomFill() {
        boolean bl = false;
        int n = 19;
        while (n >= 0 && !bl) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n % 2 == 0) {
                n5 = 9;
                while (n5 >= 0 && !bl) {
                    if (!this.isOccupied(n, n5)) {
                        n4 = (int)(Math.random() * 255.0);
                        n3 = (int)(Math.random() * 255.0);
                        n2 = (int)(Math.random() * 255.0);
                        board[n][n5].setOccupied(true);
                        board[n][n5].setColor(new Color(n4, n3, n2));
                        bl = true;
                    }
                    --n5;
                }
            } else {
                n5 = 0;
                while (n5 < 10 && !bl) {
                    if (!this.isOccupied(n, n5)) {
                        n4 = (int)(Math.random() * 255.0);
                        n3 = (int)(Math.random() * 255.0);
                        n2 = (int)(Math.random() * 255.0);
                        board[n][n5].setOccupied(true);
                        board[n][n5].setColor(new Color(n4, n3, n2));
                        bl = true;
                    }
                    ++n5;
                }
            }
            --n;
        }
        if (!bl) {
            this.boardFull = true;
        }
    }

    public boolean isBoardFull() {
        return this.boardFull;
    }

    public boolean isOccupied(int n, int n2) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (n >= 20 || n2 >= 10 || n2 < 0) {
                    bl = true;
                    break block4;
                }
                if (n < 0) {
                    bl = false;
                    break block4;
                }
                bl = board[n][n2].isOccupied();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ERROR:  TrisGameBoard.isOccupied() -- Array index out of bounds");
                System.err.println("\tBoard space:     " + n + ", " + n2);
                System.err.println("\tException message:  " + arrayIndexOutOfBoundsException.getMessage());
                System.exit(1);
            }
        }
        return bl;
    }

    public Color getColor(int n, int n2) {
        return board[n][n2].getColor();
    }

    public void addToBoard(TrisGamePiece trisGamePiece, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            this.gameData.scoreEvent(5);
            n3 = 0;
            while (n3 < trisGamePiece.getSize()) {
                n4 = 0;
                while (n4 < trisGamePiece.getSize()) {
                    int n5;
                    int n6;
                    if (trisGamePiece.isOccupied(n3, n4) && this.isInBounds(n6 = n + n3 - 2, n5 = n2 + n4 - 12)) {
                        board[n6][n5].setOccupied(true);
                        board[n6][n5].setColor(trisGamePiece.getColor());
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("EXCEPTION:  TrisGameBoard.addToBoard() -- Array index out of bounds");
            System.err.println("\tBoard space:  " + (n + n3) + ", " + (n2 + n4));
            System.err.println("\tPiece space:  " + n3 + ", " + n4);
            System.err.println("\tException message:  " + arrayIndexOutOfBoundsException.getMessage());
            System.exit(1);
        }
    }

    public void checkRows() {
        int n = 0;
        int n2 = 0;
        while (n2 < 20) {
            if (this.checkRow(n2)) {
                this.gameData.incrementLineCount();
                TrisGameData.rowFlasher.flashRow(n2);
                this.rowFlags[n2] = true;
                ++n;
            }
            ++n2;
        }
        TrisGameData.rowFlasher.setFlashDuration(n * 10);
        this.gameData.scoreEvent(n);
    }

    public void removeRows() {
        int n = 0;
        while (n < 20) {
            if (this.rowFlags[n]) {
                this.removeRow(n);
                this.rowFlags[n] = false;
            }
            ++n;
        }
    }

    private boolean checkRow(int n) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < 10) {
            if (!board[n][n2].isOccupied()) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public void render(Graphics graphics) {
        int n = 240;
        int n2 = 40;
        int n3 = 0;
        while (n3 < 20) {
            int n4 = 0;
            while (n4 < 10) {
                if (board[n3][n4].isOccupied()) {
                    graphics.setColor(board[n3][n4].getColor());
                    graphics.fill3DRect(n + n4 * 20, n2 + n3 * 20, 19, 19, true);
                } else if (this.gridOn) {
                    graphics.setColor(Color.darkGray);
                    graphics.draw3DRect(n + n4 * 20, n2 + n3 * 20, 19, 19, false);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void toggleGrid() {
        this.gridOn = !this.gridOn;
    }

    private void removeRow(int n) {
        int n2 = n;
        while (n2 > 0) {
            int n3 = 0;
            while (n3 < 10) {
                board[n2][n3].setColor(board[n2 - 1][n3].getColor());
                board[n2][n3].setOccupied(board[n2 - 1][n3].isOccupied());
                ++n3;
            }
            --n2;
        }
    }

    public boolean isInBounds(int n, int n2) {
        return n >= 0 && n < 20 && n2 >= 0 && n2 < 10;
    }
}

