/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public abstract class MHDisplayModeChooser {
    private static GraphicsEnvironment env;
    private static GraphicsDevice device;
    private static GraphicsConfiguration gc;
    private static BufferStrategy bufferStrategy;
    private static Canvas canvas;
    private static JFrame frame;
    private static DisplayMode[] BEST_DISPLAY_MODES;

    private static DisplayMode getBestDisplayMode(GraphicsDevice graphicsDevice) {
        int n = 0;
        while (n < BEST_DISPLAY_MODES.length) {
            DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
            int n2 = 0;
            while (n2 < displayModeArray.length) {
                if (displayModeArray[n2].getWidth() == BEST_DISPLAY_MODES[n].getWidth() && displayModeArray[n2].getHeight() == BEST_DISPLAY_MODES[n].getHeight() && displayModeArray[n2].getBitDepth() == BEST_DISPLAY_MODES[n].getBitDepth()) {
                    return BEST_DISPLAY_MODES[n];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public static BufferStrategy getBufferStrategy() {
        return frame.getBufferStrategy();
    }

    public static Canvas getCanvas() {
        return canvas;
    }

    public static Rectangle getScreenBounds() {
        return frame.getBounds();
    }

    public static boolean setFullScreenWindow(JFrame jFrame) {
        boolean bl = true;
        env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        device = env.getDefaultScreenDevice();
        gc = device.getDefaultConfiguration();
        frame = jFrame = new JFrame(gc);
        canvas = new Canvas(gc);
        frame.getContentPane().add(canvas);
        frame.setUndecorated(true);
        frame.setIgnoreRepaint(true);
        device.setFullScreenWindow(frame);
        if (device.isDisplayChangeSupported()) {
            DisplayMode displayMode = MHDisplayModeChooser.getBestDisplayMode(device);
            if (displayMode != null) {
                device.setDisplayMode(displayMode);
            } else {
                bl = false;
            }
        }
        frame.createBufferStrategy(2);
        return bl;
    }

    static {
        BEST_DISPLAY_MODES = new DisplayMode[]{new DisplayMode(640, 480, 32, 0), new DisplayMode(640, 480, 16, 0), new DisplayMode(640, 480, 8, 0)};
    }
}

