/***************************************************************************
 *   Copyright (C) 2003 by beltorak                                        *
 *   beltorak@ananzi.co.za                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

/* This struct contains everything needed for the creation of
the option componants for get_opt(); also has help strings.
	type may be one of
		'y' - option that requires an argument
		'n' - option that requies no argument
		'o' - option with an optional argument
		'd' - continuation of an option desription
		't' - help text heading (help_str -> the displayed text)
		'\n'- blank line
		0   - end of option list
*/

struct tbt_option {
	int		(*opt_func)( char* arg );
	char		short_opt;
	char*		long_opt;
	char		type;
	char*		arg_name;
	char*		help_str;
};

/* Prints option help */
void
cat_option_help( struct tbt_option* option_list );

char*
get_short_optstring(struct tbt_option* option_list );

struct option*
get_long_opttable(struct tbt_option* option_list );

/* This function takes the results from getopt_long() and
runs the function specified in the option_list.
Returns the results of the function called, or
-1 if the option passed is not found.  Prefers
short_opt to long_opt.  */
int
process_option( struct tbt_option* opt_list, char short_opt, const char* long_opt );

#endif /* OPTIONS_H */
