; string.S
; various utilities for string functions
; beltorak (c) 2002
; released under the GPL

%ifndef __string_S__
%define __string_S__

; most of the time eax is used as a general scratch pad;
; to save the value of eax, place "%define SAVE_EAX" in
; your source
; may be expanded to include other regs;
;
%ifdef SAVE_EAX
  %macro _push 1
	push	%1
  %endm
  %macro _pop 1
  	pop	%1
  %endm
%else
  %macro _push 1
	;push	%1	; not required
  %endm
  %macro _pop 1
	;pop	%1	; not required
  %endm
%endif

; -- zstrncmp ------------------------------------
; requires:
;	esi -> str (may be null terminated)
;	edi -> str (may be null terminated)
;	ecx = max chars to check
; returns:
;	esi, edi untouched
;	ecx = chars checked ( negative if fail )
;	success
;	  * the NULL terminator matches any char;
;	    check for IFS is you need to.
;	fail
;	  sign flag set
;	  (esi, edi) - ecx -> point of difference
zstrncmp:
	_push	eax
	push	esi
	push	edi
	push	ecx
	repe cmpsb
	pop	eax
	jcxz	.match
	dec	edi
	dec	esi
	cmp	[edi], byte _NULL
	jz	.match
	cmp	[esi], byte _NULL
	jnz	.nomatch
	sub	eax, ecx
.match
	mov	ecx, eax
.return
	pop	edi
	pop	esi
	_pop	eax
	ret
.nomatch:
	sub	ecx, eax
	inc	ecx
	xor	eax, eax
	dec	eax
	jmp	.return
; -- end zstrncmp --------------------------------

; -- zstrnlen ------------------------------------
; requires: edi -> zstr; ecx = max char length
; returns: edi untouched
;	success: ecx = len (not including null);
;	fail: ecx = -1; sign flag set (test with js)
; * note: may segfault if edi+ecx -> memory out of bounds
;
zstrnlen:
	_push	eax
	push	edi
	push	ecx
	xor	eax, eax
	repne scasb
	jz	.return		; if \0 not found then
	pop	eax		; get rid of max_len
	jmp	.ret
.return:
	mov	eax, ecx	; else calc zstrlen
	pop	ecx
	sub	ecx, eax
.ret:
	dec	ecx		; if ecx=0, this sets the sign flag;
	pop	edi		; else it discounts trailing \0 from strlen
	_pop	eax
	ret
; -- end zstrnlen --------------------------------


; -- zstrncat ------------------------------------
; concatenates zstr_1 @esi + zstr_2 @edi to [ebp]
; requires:
;	esi -> zstr_1
;	edi -> zstr_2
;	ebp -> writable buffer able to hold str_1+str_2
;	ecx = max length of new str; will truncate.
; returns:
;	edi, esi, ebp untouched (ebp -> new zstr)
;	ecx = strlen( [ebp] )
;	* [ebp] will not be null terminated if
;	  ecx < zstrnlen( [esi] + [edi] -1 ).
;	  a null will be appended to [ebp] if
;	  ecx > zstrnlen( [esi] + [edi] -2 ).
;	  the null will be at [ebp + ecx].
; special cases:
;	to use as zstrncp; point esi or edi to a null.
;	to use as zstrnappend; set ebp = esi.
zstrncat:
	_push	eax
	push	esi
	push	edi
	push	ebp
	mov	eax, 0x200	; the .do/.loop is done twice
	xchg	ebp, edi	; edi -> empty buff; ebp -> str2
.do:
	lodsb
	_cmp	al, 0		; end of string yet?
	jz	.loop
	stosb
	loop	.do
	jmp	.done_
.loop:
	dec	byte ah
	jz	.done_
	mov	esi, ebp	; esi -> str 2
	jmp	.do
.done_:
	jecxz	.done		; if there is room left
	stosb			; append the trailing null
.done:
	dec	edi		; calc length
	pop	ebp
	sub	edi, ebp
	mov	ecx, edi
	pop	edi
	pop	esi
	_pop	eax
	ret
; -- end zstrncat --------------------------------

%endif
