; Make Fun Of DOS XP for Fun and Profit
; beltorak (c) 2002;
; released under the GPL
; doxp.s
; idea borrowed from "char X[11]" from
;   www.fuckmicrosoft.com

%include "system.inc"
%include "string.S"
GLOBAL _start

SECTION .text

; ------- READ ONLY DATA ---------------------------------------------------------

IFS:
nl 		db 	_nl
db 			_space
db 			_tab
db 			_NULL
IFS_count 	equ	$ - IFS

welcome_msg:
db '**************************************************', _nl
db "Welcome to Micro$haft's Finest Terminal Emulator", _nl
db "                    !! DOS XP !! ", _nl, _nl
db "Supported Commands are:", _nl
welcome_msg_len equ $ - welcome_msg

prompt 		db 	_nl, "C:\> "
prompt_len equ $ - prompt

overflow_msg: 	db 	"Buffer Overflow! DOXP KERNEL PANICK", _nl
overflow_msg_len equ 	$ - overflow_msg

invalid_cmd_msg_head: 	db 'The kernel does not recognize "'
invalid_cmd_msg_head_len equ $ - invalid_cmd_msg_head
invalid_cmd_msg_tail: 	db '" as a valid command, executable, or filename.', _nl
invalid_cmd_msg_tail_len equ $ - invalid_cmd_msg_tail

kernel_panic_msg: 	db 	_nl, "DOXP KERNEL PANIC!", _nl
			db 	"HEAP CORRUPT! STACK CORRUPT! BILLG CORRUPT! BAILING!", _nl, _nl
			db 	"You may now restart your computer.", _nl
			db 	"__________________________________", _nl, _nl
kernel_panic_msg_len 	equ 	$ - kernel_panic_msg


; This error message is serious. It represents stupidity of the coder.
fixme_bad_internal_command_msg:
			db "It appears that the Micro$haft team had a little "
			db "too much to drink when they coded this command.", _nl
			db "It is too long.", _nl
fixme_bad_internal_command_msg_len equ $ - fixme_bad_internal_command_msg


;---------------------------------------------------------------------------
list_start: ; ---- starts the command link list.

help_lnk: 	; ---- help stuff here -- for consistency, if nothing else
dd 			ver_lnk 		; ptr to the next link list item
help_func: 	dd 	giveHelp 		; ptr to help function
help_cmd: 	db 	"help" 			; what the command is recognized as
		db 		0 		; null byte to terminate string
		
		; what ever else makes for ease of reference by the function
		; can be put here.
help_msg: 	db 	"I am the DOXP Assistant here to help you.", _nl
help_msg_len 	equ 	$ - help_msg

no_help_msg: 	db 	"There is no help for you.", _nl
no_help_msg_len equ 	$ - no_help_msg


ver_lnk: 	; ---------- version stuff here ------------
		dd 	exit_lnk
ver_func: 	dd 	giveVersion
ver_cmd: 	db 	"ver"
		db	0
ver_msg: 	db 	"DOXP version INCOMPLETE. Ain't you glad you payed for this?", _nl
ver_msg_len 	equ 	$ - ver_msg

help4ver: 	db 	"you want what for what ?!?!", _nl
help4ver_len 	equ 	$ - help4ver


exit_lnk: ; --------- the (haha) exit command stuff here
		dd 	0 		; indicates the end of the link list
exit_func: 	dd 	false_exit
exit_cmd: 	db 	"exit"
		db 	0
exit_msg: 	db 	"We at Micro$haft will not let you go.", _nl
exit_msg_len 	equ 	$ - exit_msg

; ------- END COMMAND LINK LIST -------------------------


_start:
    mov		ebp, 2 			; this is the invalid command threshhold
    sys_write 	STDOUT, welcome_msg, welcome_msg_len
    mov esi, 	list_start 		; spit out command names
  .cmd_list_loop:
    lodsd
    push 	eax 			; save next link ptr
    lodsd 				; discard func ptr
    mov 	ecx, 0x20 		; completely arbitrary command length print limit.
    mov 	edi, esi 		; now edi -> command name
    mov 	[iovect], esi 		; create iovect struct to print command name
    call 	zstrnlen 		; ecx = zstrnlen( [edi] )
    mov		eax, ecx
    lea 	edi, [iovect+4]
    stosd
    mov 	eax, nl
    stosd
    mov 	[edi], dword 1
    sys_writev 	STDOUT, iovect, 2
    pop 	esi 			; is there a next item?
    _cmp 	esi, 0
    jnz 	.cmd_list_loop
  .cmd_loop: 				; note: three invalid commands to exit
    sys_write STDOUT, prompt, prompt_len

    mov 	ecx, input_buffer_len 	; clear input buffer
    mov 	edi, input_buffer
    _mov 	eax, 0
    rep stosb
  .buff_clear:
    lea 	edi, [iovect] 		; readv input;
    mov 	eax, input_buffer
    stosd
    mov 	eax, input_buffer_len
    stosd
    sys_readv 	STDIN, iovect, 1 	; eax = num chars read; errno on error.
    cmp		eax, 1			; null command ;)
    jbe		.cmd_loop
    cmp 	eax, input_buffer_len 	; check for buffer overflow
    jb		.do_foreach
      sys_write STDOUT, overflow_msg, overflow_msg_len
      mov	edi, iovect
      mov 	eax, input_buffer
      stosd
      mov 	eax, input_buffer_len
      stosd
    .flush_STDIN:
      sys_readv STDIN, iovect, 1 	; manually flush the buffer
      cmp 	eax, input_buffer_len
      jnb 	.flush_STDIN
    dec ebp
    jns 	.cmd_loop 		; continue if invalid_count threshhold >= 0
    jmp .exit_cmd_loop
  .do_foreach: 				; this loop checks the input with each command name
    mov 	[edi], dword input_buffer ; preps for invalid command msg
    mov 	esi, input_buffer 	; calculate command string length
  .find_IFS:
      mov 	edi, IFS
      mov 	ecx, IFS_count
      lodsb
      repnz scasb
    jnz 	.find_IFS
    dec 	esi
    mov 	ebx, input_buffer
    sub 	esi, ebx		; esi = input command length
    mov 	[iovect+12], esi
    mov 	esi, list_start 	; list of valid commands given in CODESEG
  .foreach:
      lodsd
      push 	eax 			; save next link addr
      lodsd
      mov 	ebx, eax 		; keep function addr in ebx for ease of reference
      mov 	edi, esi
      mov 	ecx, input_buffer_len
      call 	zstrnlen 		; get length of internal command
      jns	.i_cmd_good		; if no null was found in command name, flog the coder
        call	fixme_bad_internal_command
    .i_cmd_good:
      mov 	edi, input_buffer
      call 	zstrncmp 		; compare null term. str [esi] with input_buffer [edi]
      js 	.next 			; does not match this command, try the next one
      lea 	esi, [edi + ecx]
      mov 	ecx, IFS_count 		; check byte in input_buffer for IFS
      lodsb
      mov 	edi, IFS
      repnz scasb
      jnz 	.next 			; if no match, go to next command
					; else command is (?)valid.
    .strip:
      mov 	edi, IFS 		; strip remaining whitespace
      mov 	ecx, IFS_count
      lodsb
      cmp 	esi, input_buffer + input_buffer_len
      jz 	.end_strip
      repnz scasb
      _cmp 	ecx, 0
      jnz 	.strip
    .end_strip:
      dec 	esi
      call 	ebx 			; [esi] -> whatever is left on the command line
					; if the proceedure needs it.
      pop 	eax 			; the next command in link list is discarded;
      _cmp 	ebp, 0
      js 	.exit_cmd_loop 		; if invalid command count > threshhold,
					; exit the command loop
      jmp 	.cmd_loop 		; else continue
    .next:
      pop 	esi 			; retrieve next link addr
      _cmp 	esi, 0
      jnz 	.foreach
  .done_foreach: 			; invalid command.
    mov 	edi, iovect 		; inv_cmd_msg_head prep
    mov 	eax, invalid_cmd_msg_head
    stosd
    mov 	eax, invalid_cmd_msg_head_len
    stosd
    _add 	edi, 8 			; input buffer already in iovect
    mov 	eax, invalid_cmd_msg_tail
    stosd
    mov 	eax, invalid_cmd_msg_tail_len
    stosd
    sys_writev 	STDOUT, iovect, 3 	; display error
    dec 	ebp
    jns 	.cmd_loop
.exit_cmd_loop:
    sys_write 	STDOUT, kernel_panic_msg, kernel_panic_msg_len
    sys_exit 	0 			; exiting DOS is ALWAYS a good thing

;** serious flaw: the coder should be flogged. **
fixme_bad_internal_command:
    sys_write 	STDERR, fixme_bad_internal_command_msg, fixme_bad_internal_command_msg_len
    sys_write 	STDERR, esi, input_buffer_len
    sys_exit 	255

; ----- END START: ----------------------------------------------------------------------

; -- giveHelp --------------------------------------------------------------------
giveHelp:
    _cmp 	[esi], byte 0
    jz 		.help
    sys_write 	STDOUT, no_help_msg, no_help_msg_len
    dec 	ebp
    ret
  .help
    sys_write 	STDOUT, help_msg, help_msg_len
    ret
; // -- END giveHelp -------------------------------------------------------------

; -- giveVersion -----------------------------------------------------------------
giveVersion:
    cmp 	word [esi], "/?"
    jnz 	.ver
    sys_write 	STDOUT, help4ver, help4ver_len
    dec 	ebp
    ret
  .ver
    sys_write 	STDOUT, ver_msg, ver_msg_len
    ret
; -- end giveVersion -------------------------------------------------------------

; -- false_exit ------------------------------------------------------------------
false_exit:
    sys_write 	STDOUT, exit_msg, exit_msg_len
    dec 	ebp
    ret
; -- end false_exit --------------------------------------------------------------


;-- writable data ----------------------------------------------------------------

SECTION .bss
iovect 		resd 	6 			; for sys_readv and sys_writev
						; struct { *buff_x, buff_x_len }
input_buffer	resb 	200
input_buffer_len equ 	$ - input_buffer


