/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   prserversettings.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <sys/time.h>

#include "prserversettings.h"

#include <xmalloc.h>
#include <xstring.h>
#include <state.h>
#include <defaults.h>
#include <logutils.h>
#include <procprivs.h>
#include <serverconf.h>

/* Prints the current server settings. */
void
show_server_settings( void ) {
        println("Server Settings:");
	print_configfile();
	print_authport();
        print_logfile();
        print_pidfile();
	print_userdir();
	print_max_queries();
	print_cache_age();
	print_runas_uid();
	print_runas_gid();
} /* -- end show_settings() -- */

/* prints the uid to run as */
void
print_runas_uid(void) {
        struct passwd* pwd = getpwuid(proc_uid.uuid);
        char* uid;
        if(pwd) {
        	uid = pwd->pw_name;
        } else {
        	uid = "no username in /etc/passwd";
        }
	uid_t orig;
	strtouidt(&orig, default_runas_uid);

	print_default_marker_if(proc_uid.uuid == orig);
	println("User to run as == %lu (%s)", proc_uid.uuid, uid);
        if( ! proc_root )
        	println("      Note: ignored when not root");
} /* -- end print_runas_uid() -- */

/* prints the gid to run as */
void
print_runas_gid(void) {
        struct group* grp = getgrgid(proc_uid.ugid);
        char* gid;
        if(grp) {
        	gid = grp->gr_name;
        } else {
        	gid = "no name in /etc/group";
        }

	gid_t orig;
	strtogidt(&orig, default_runas_gid);
	print_default_marker_if(proc_uid.ugid == orig);
	println("Group to run as == %lu (%s)", proc_uid.ugid, gid);
        if( ! proc_root )
        	println("      note: ignored when not root");
} /* -- end print_runas_gid() -- */

/* Prints the age of cached entries */
void
print_cache_age( void ) {
	time_t orig;
	strtotime(&orig, default_cache_age);
	print_default_marker_if(server.cache_age == orig);
	println("Keep cached entries for %d seconds", server.cache_age);
} /* -- end print_cache_age() -- */

/* Prints the user_dir.  Prefixes with '*' if needed. */
void
print_userdir( void ) {
        print_default_marker_if( ! xstr_is_equal(server.userdir, default_user_dir) );
        if( server.userdir )
        	println("user_dir == %s", server.userdir);
        else
        	println("Not using user files");
} /* -- end print_user_dir() -- */

/* Prints the logfile.  Prefixes with '*' if needed. */
void
print_logfile( void ) {
	print_default_marker_if( ! xstr_is_equal(server.logfile, default_logfile) );
        if( server.logfile )
	        println("logfile == %s", server.logfile);
        else
        	println("logging to stderr");
} /* -- end print_logfile() -- */

/* Prints the pidfile.  Prefixes with '*' if needed. */
void
print_pidfile( void ) {
	print_default_marker_if( ! xstr_is_equal(server.pidfile, default_pidfile) );
        if( server.pidfile )
        	printf("pidfile == %s\n", server.pidfile);
        else
        	printf("(pidfile will not be written)\n");
} /* -- end print_pidfile() -- */

/* prints the configfile */
void
print_configfile(void) {
	print_default_marker_if( ! xstr_is_equal(server.configfile,
			default_configfile) );
        if( server.configfile )
        	println("config file == %s", server.configfile);
        else
        	println("No config file set.  Using compiled in defaults");
} /* -- end print_configfile() -- */


/* -- end prserversettings.c -- */
