/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   meta.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdbool.h>

#include "meta.h"

#include <tbtopt.h>
#include <init.h>

/* Prints the help */
int
cat_help(void) {
	cat_version();
        cat_copyright();
        cat_option_help(cmdline_options);
	printf("Send bugreports to \"beltorak@phreaker.net\"\n");
	TBTOPT_EXIT_SUCCESS = true;
        return 0;
} /* -- end cat_help() -- */

/* Prints the copyright blurb */
void
cat_copyright(void) {
	printf("Copyright 2004 by Trevor \"beltorak\" Torrez.\n");
        printf("Released under the GPL.\n");
} /* -- end cat_copyright() -- */

/* Prints the version */
int
cat_version(void) {
	printf(PACKAGE " version " VERSION "\n");
	TBTOPT_EXIT_SUCCESS = true;
        return 0;
} /* -- end cat_version() -- */

/* -- end meta.c -- */
