/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   xstring.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef xstring_H
#define xstring_H 1

#if defined(HAVE_STRING_H)
#include <string.h>
#endif

#include <stdbool.h>
#include <stdarg.h>

/* Returns true if the string ptr is either NULL or ->'\0'.  */
#define xstr_is_nil(str) \
	( ! ((str) && *(str)) )


/* Checks to see if strings match */
#define xstr_is_equal(s1, s2) \
	( xstrcmp(s1, s2) == 0 ? (0==0) : (0==1) )

/*
if()
*/

size_t
xstrlen(char* str);

size_t
xstrnlen(char* str, size_t len);

int
xstrcmp(char* apple, char* orange);

int
xstrncmp(char* apple, char* orange, size_t len);

bool
xstr_has_prefix(char* str, char* prefix);

bool
xstr_has_suffix(char* str, char* suffix);

char*
xstrdup(char* str);

char*
xstrndup(char* str, size_t len);

char*
xsprintf(char* fmt, ...);

#endif /* xstring_H */
