/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   xstring.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdbool.h>

#if defined(HAVE_STRING_H)
#include <string.h>
#endif

#include "xstring.h"

#include <xmalloc.h>

size_t
xstrlen(char* str)
{
	if( xstr_is_nil(str) )
		return 0;
#if defined(HAVE_STRLEN)
	return strlen(str);
#else
	int k = 0;
	while(*str++)
		++k;
	return k;
#endif
}

size_t
xstrnlen(char* str, size_t len)
{
	if( xstr_is_nil(str) )
		return 0;
#if defined(HAVE_STRNLEN)
	return strnlen(str, len);
#else
	int k = 0;
	while(*str++ && k < len)
		++k;
	return k;
#endif
}

int
xstrcmp(char* apple, char* orange)
{
	/* If the pointers are equal... */
	if( apple == orange )
		return 0;

	/* If they are both nil */
	if( xstr_is_nil(apple) && xstr_is_nil(orange) )
		return 0;

	/* If one is nil, it comes first ascii-betically */
	if( xstr_is_nil(apple) && ! xstr_is_nil(orange) )
		return -1;
	if( ! xstr_is_nil(apple) && xstr_is_nil(orange) )
		return 1;

	/* Now that we have ensured that we have not passed a NULL ptr... */
#if defined(HAVE_STRCMP)
	return strcmp(apple, orange);
#else
	int c = 0;
	while( *apple && *orange && (*apple++ == *orange++) )
		;
	if( *apple > *orange )
		return 1;
	if( *apple < *orange )
		return -1;
	return 0;
#endif
}

int
xstrncmp(char* apple, char* orange, size_t len)
{
	/* If the max compare size is 0, then they are both equal */
	if( ! len )
		return 0;
	/* If the pointers are equal... */
	if( apple == orange )
		return 0;

	/* If they are both nil */
	if( xstr_is_nil(apple) && xstr_is_nil(orange) )
		return 0;

	/* If one is nil, it comes first ascii-betically */
	if( xstr_is_nil(apple) && ! xstr_is_nil(orange) )
		return -1;
	if( ! xstr_is_nil(apple) && xstr_is_nil(orange) )
		return 1;

	/* Now that we have ensured that we have not passed a NULL ptr... */
#if defined(HAVE_STRNCMP)
	return strncmp(apple, orange, len);
#else
	int k = 0;
	while( *apple && *orange && (*apple++ == *orange++) && (k++ < len) )
		;
	if( k == len )
		return 0;
	if( *apple > *orange )
		return 1;
	if( *apple < *orange )
		return -1;
	return 0;
#endif
}

bool
xstr_has_prefix(char* str, char* prefix)
{
	if( xstr_is_nil(str) || xstr_is_nil(prefix) )
		return false;

	return ( xstrncmp(str, prefix, xstrlen(prefix)) ? false : true );
}

bool
xstr_has_suffix(char* str, char* suffix)
{
	if( xstr_is_nil(str) || xstr_is_nil(suffix) )
		return false;

	return ( xstrcmp(str + xstrlen(str) - xstrlen(suffix), suffix) ? false : true );
}
/*
if()
*/

char*
xstrdup(char* str)
{
	if( ! (str && *str) )
		return NULL;
#if defined(HAVE_STRDUP)
	char* c = strdup(str);
	if( ! c )
		xmalloc_exit(-1);
	xmalloc_ptr_ref(c);
	return c;
#else
	char* c = str;
	while(c++)
		;
	char* ret = xmalloc(c - str);
	while( *str )
		*ret++ = *str++
	return ret;
#endif
}

char*
xstrndup(char* str, size_t len)
{
	if( xstr_is_nil(str) || ! len )
		return NULL;

#if defined(HAVE_STRNDUP)
	char* s = strndup(str, len);
	if( ! s )
		xmalloc_exit(-1);
	xmalloc_ptr_ref(s);
	return s;
#else
	size_t slen = xstrlen(str) + 1;
	len = ( (len < slen) ? len : slen );
	char* s = xmalloc(len);
	char* i = s;
	while( i - s < len )
		*i++ = *str++;
	*i = 0;
	return s;
#endif
}
/*
if()
*/

char*
xsprintf(char* fmt, ...)
{
	char* r = NULL;
	va_list ap;
#if defined(HAVE_ASPRINTF)
	va_start(ap, fmt);
	int rc = vasprintf(&r, fmt, ap);
	va_end(ap);
	if( rc < 0 ) {
		fprintf(stderr, "vasprintf failed\n");
		xmalloc_exit(-1);
	}
	xmalloc_ptr_ref(r);
#else
	size_t size = 100;
	r = xmalloc(size);
	while( true ) {
		/* Try to print in the allocated space. */
		va_start(ap, fmt);
		int n = vsnprintf(r, size, fmt, ap);
		va_end(ap);
		/* If that worked, return the string. */
		if (n > -1 && n < size)
			return p;
		/* Else try again with more space. */
		if (n > -1)    /* glibc 2.1 */
			size = n+1; /* precisely what is needed */
		else           /* glibc 2.0 */
			size *= 2;  /* twice the old size */
		p = xrealloc( p, size );
	}
#endif
	return r;
}


/* -- end xstring.c -- */
