/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   xmalloc.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef xmalloc_H
#define xmalloc_H 1

#include <sys/types.h>
#include <stdbool.h>

/* Wrappers for allocating stuff.  Terminates the app on failure.
Can you tell I've been reading glib?  */

/* Exits the app or thread, whichever is relevent */
void
xmalloc_exit(int rc);

/* Allocates bytes */
void*
xmalloc(size_t bytes);

/* Allocates room for a number of structures */
#define xnew(type, num)		(type*) xmalloc(num * sizeof(type))

/* Callocates bytes */
void*
xcalloc(size_t size, size_t num);

/* Callocates a number of structures */
#define xnew0(type, num)	(type*) xcalloc(sizeof(type), num)

/* Re allocates to size bytes.
xrealloc(p, 0) == xfree(p);
xrealloc(0, s) == xmalloc(s); */
void*
xrealloc(void* p, size_t s);

/* Warns if the ptr is NULL or invalid. */
void
xfree(void* p);

/* NULL the pointer after freeing */
#define xnullfree(p)	{ if(p) { xfree(p); p = NULL; } }



/* -- public xmptrs methods -- */
/* Adds a (non-duplicate) pointer to the list */
void
xmalloc_ptr_ref(void* p);

/* Removes a ptr from the list. */
void
xmalloc_ptr_unref(void* p);


#endif /* xmalloc_H */
