/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   tbtopt.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef tbtopt_H
#define tbtopt_H 1

/* This struct contains everything needed for the creation of
the option componants for get_opt(); also has help strings.
	type may be one of
		'y' - option that requires an argument
		'n' - option that requies no argument
		'o' - option with an optional argument
		'd' - continuation of an option desription
		't' - help text heading (help_str -> the displayed text)
		'\n'- blank line
		0   - end of option list
*/

struct tbt_option {
	int		(*opt_func)();
	char		short_opt;
	char*		long_opt;
	char		type;
	char*		arg_name;
	char*		help_str;
};

/* Options that should exit without indicating an error
(such as requesting help) set this flag to true */
extern int TBTOPT_EXIT_SUCCESS;

/* Prints option help */
void
cat_option_help( struct tbt_option* option_list );

char*
get_short_optstring(struct tbt_option* option_list );

struct option*
get_long_opttable(struct tbt_option* option_list );

/* This function takes the results from getopt_long() and
runs the function specified in the option_list.
Returns the results of the function called, or
-1 if the option passed is not found.  Prefers
short_opt to long_opt.  */
int
process_option( struct tbt_option* opt_list, char short_opt, const char* long_opt );

/* Processes the passed string array as a command line.
Returns 0 on success, a positive integer if there are
non-option argv elements left, in which case the return
value is the index of the first non-option argv element,
or a -1 on error.  If TBTOPT_EXIT_SUCCESS == true, it
returns 0 */
int
process_argv( struct tbt_option* option_list, int argc, char** argv );


#endif /* tbtopt_H */
