/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtoulong.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include "strtotype.h"

#include <logutils.h>
#include <xmalloc.h>
#include <xstring.h>

/* Translates a string to an unsigned long.
0 on success, -1 on error. */
int
strtoulong(ulong* u, char* s) {
	if( xstr_is_nil(s) ) {
		carp("Passed value is NIL");
		return -1;
	}
	char* end;
	*u = strtoul(s, &end, 10);
	if( *end ) {
		carp("Invalid number: %s", s);
		return -1;
	}

	return 0;
} /* -- end strtoulong() -- */


/* -- end strtoulong.c -- */
