/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtotime.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <time.h>

#include "strtotype.h"

#include <xmalloc.h>
#include <xstring.h>
#include <logutils.h>


/* Translates a string to a time_t.
Returns 0 on sucess, -1 on error. */
int
strtotime(time_t* t, char* s) {
	if( xstr_is_nil(s) ) {
		carp("time is NIL");
		return -1;
	}

	char* end = NULL;
	struct tm btm;
	memset(&btm, 0, sizeof(btm));

	ulong tmp = strtoul(s, &end, 10);
	if( ! tmp )
		tmp = 1;

	if( ! xstr_is_nil(end) ) {
		switch(*end) {
		case 'y':
			tmp *= 52;
		case 'w':
			tmp *= 7;
			/* This is kinda rediculous, but hey */
			if( *end == 'y')
				tmp += 1;
		case 'd':
			tmp *= 24;
		case 'h':
			tmp *= 60;
		case 'm':
			tmp *= 60;
		case 's':
			break;
		default:
			carp("Invalid time suffix: %c", *end);
			return -1;
		}
	}
	*t = (time_t) tmp;

	return 0;
} /* -- end strtotime() -- */


/* -- end strtotime.c -- */
