/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   serverconf.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef serverconf_H
#define serverconf_H 1

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>

/* Most of these have no real purpose, but they
are here if we want to add them as a command line
option */
struct server_config_modified {
	uint		configfile:1,
			logfile:1,
			pidfile:1,
			userdir:1,
			authport:1,
			runas_uid:1,
			runas_gid:1,
			max_queries:1,
			cache_age:1;
};

struct server_config {
	char*		configfile;
	char*		logfile;
	char*		pidfile;
	FILE*		pidFP;
	char*		userdir;

	uint		authport;
	int		auth_socket;

	/*
	 * These are held in the procprivs module
	 *
	 * uid_t	runas_uid;
	 * gid_t	runas_gid;
	 *
	 */

	uint		max_queries;
	time_t		cache_age;

	struct server_config_modified
			is_modifed;
};

extern struct server_config server;

#endif /* serverconf_H */
