/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   response.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef response_H
#define response_H 1

#include <strtotype.h>
#include <reutils.h>
#include <ansconf.h>

extern struct timeval last_clean;

/*******
 * Answer caching utils
 *******/

/* Gets a cached answer for a user; creates one if necessary.
Returns 0 if no error, ET_UNKNOWN on error */
c_error_t
get_cached_answer(AnswerConfig** ac, uid_t owner, char* username);

/* This retrieves a cached answer for the passed uid.
If the cached answer exists, it is returned in the
passed ptr. */
void
check_cache(AnswerConfig** ac, uid_t owner);

/* Cleans out expired cached entries. */
void
clean_cache( void );

/* Checks to see if a cached answer is outdated.
Returns true if the cached answer is outdated, false
otherwise.  */
uint
is_outdated(AnswerConfig* ac);


#endif /* response_H */
