/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   init.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef init_H
#define init_H 1

/* === function reference === */

/* Begins the init process.  Calls all relevent
initialization routines.  Returns 0 on success,
-1 on error, or a +1 when the program must quit
but not due to an error (help requested). */
int
cidentd_init(int argc, char** argv);

/* Calls every default setting function.
Returns o on success, -1 on error. */
int
set_defaults(void);

/* Calls every applicable show setting function */
void
show_settings( void );

/* Sets the show_settings option */
int
set_show_settings( void );

/* Displays the default settings. */
int
display_defaults( void );

/* Reports a shutdown to the logfile */
void
shutdown_cidentd( void );

/* Initializes the handled signals -- ie, none */
int
init_signals( void );

/* Sets the signal handling routines */
int
install_sig_handlers( void );

/* The TERM and INT sig handler */
void
sa_cidentd_exit(int sig);

/* The USR2 signal handler */
void
sa_toggle_debug(int sig);

#endif /* init_H */
