/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   cmdline.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>

#include "cmdline.h"

#include "meta.h"
#include "init.h"

#include <logutils.h>
#include <networking.h>
#include <tbtopt.h>
#include <logfile.h>
#include <configfile.h>
#include <state.h>
#include <serverconfig.h>


struct tbt_option cmdline_options[] = {
	{	.type = 't',
        	.help_str = "Server Options"
        },
        {	&set_configfile,
        	'f', "configfile",	'y', "file",
                "Use an alternate config file"
        },
        {	&set_logfile,
        	'L', "logfile",		'y', "file",
                "Use an alternate logfile."
        },
        {	&set_authport,
        	'p', "port",		'y', "portnum",
                "Set the port to listen on"
        },
        {	&set_pidfile,
        	'P', "pidfile",		'y', "file",
                "Write the PID in this file;"
        },
        {	.type = 'd',
        	.help_str = "Use '/dev/null' to not write a pidfile"
        },
        {	&set_debug,
        	'd', "debug",		'n', NULL,
                "Reports file and line info in error reports"
        },
        {	.type = 'd',
        	.help_str = "This may be toggled at runtime using SIGUSR2"
        },
        {	.type = 'd',
        	.help_str = "Note: This is *very* noisy atm"
        },
	{	&set_nofork,
		0, "forground",		'n', NULL,
		"Do not run in the background"
	},
        {	.type = 't',
        	.help_str = "About Options"
        },
        {	&cat_help,
        	'h', "help",		'n', NULL,
                "Prints this help and exits"
        },
        {	&cat_version,
        	'V', "version",		'n', NULL,
                "Prints version and exits"
        },
        {	&set_show_settings,
        	0,   "show-settings",	'n', NULL,
                "Shows the settings after parsing the"
        },
        {	.type = 'd',
        	.help_str = "command line and config file."
        },
        {	&display_defaults,
        	0,   "display-defaults", 'n', NULL,
                .help_str = "Displays the compiled in settings."
        },
        { 0, 0, 0, 0, 0, 0}
};

/* processes the command line.  Returns 0 on success,
-1 on error, +1 on success to exit the program without
error */
int
process_cmdline(int argc, char** argv) {
	state.cmdline = TRUE;
	int retval = process_argv(cmdline_options, argc, argv);
        if( retval < 0 )
        	return -1;
        else if( retval > 0 ) {
        	report("Extra arguments at end of command");
                return -1;
        } else if( TBTOPT_EXIT_SUCCESS )
        	return 1;

        state.cmdline = FALSE;
        return 0;
} /* -- end process_cmdline() -- */

/* -- end cmdline.c -- */
