/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   defaults.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef defaults_H
#define defaults_H 1

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#if defined(NEED_DEFAULTS)
/*********
 * Some of the defines in here are integrated with the build process, and
 * may be set with the appropriate "./configure" options:
 * PKG_PREFIX : defaults to "/usr/local", set with "--prefix=xxx"
 * SYS_CONF_DIR : defaults to "PKG_PREFIX/etc", set with "--sysconfdir=xxx"
 * PKG_VAR_DIR : defaults to "PKG_PREFIX/var", set with "--localstatedir=xxx"
 ********/

/* NOTE: Do not use NULL strings ("") -- use NULL ! */

char*	default_configfile = SYS_CONF_DIR "/cidentd.conf";

	/* Must be run as root to bind to any port below 1024.
        Allowed values are numbers between 1 and 65535.  Names
        in /etc/services are accepted, the standard "auth" port
        is 113. */
char*	default_authport = "auth";

char*	default_logfile = PKG_VAR_DIR "/log/cidentd.log";

        /* Use "/dev/null" to avoid writing a pidfile */
char*	default_pidfile = PKG_VAR_DIR "/run/cidentd.pid";

        /* This is where the users' custom ident replies are stored */
char*	default_user_dir = SYS_CONF_DIR "/cidentd/userfiles";

	/* The number of maximun concurrent queries.  Note that
	the OS may impose a limit, for example Linux can only
	have 255 open file descriptors, so this setting is
	rejected if > 250. */
	char* default_max_queries = "20";

	/* The ammount of time to keep cached entries.
	Suffixes are 's' for seconds, 'h' for hours, etc.
	If no suffix is present, 's' is implied.
	Only the first letter is actually checked, so
	'month' is interpreted as 'minute'.  Use "4w". */
	char* default_cache_age = "1hour";

        /* These are ignored if not run as root */
        /* uid and gid to switch to after initializations.
        Allowed is any number or any name in /etc/passwd and /etc/group,
        with the exception of "root" or "0". */
char*	default_runas_uid = "65533";
char*	default_runas_gid = "65533";

	/* This is the default way to answer, and (unmodified) should
        be compliant with rfc-1413.  */

        /* What the default answer will be.
        Allowed values are "userid" or "error" to send either a user
        identification (specified below) or an error (also specified below) */
char*	default_answer_type = "userid";

        /* If sending a userid, allowed values are "name" or "number" to send
        either the username or the uid number respectively.  Alternately you
        can specify a literal string to send as the default by using
        "literal=send this". */
char*	default_userid = "name";

	/* The default character set to send with the userid.  If left unspecified
        (by using NULL) then the charset is not sent. */
char*	default_charset = "US-ASCII";

	/* The default OS-TYPE to report.  If left unspecified, the OSTYPE is
        reported as "OTHER" */
char*	default_ostype = "LINUX";

	/* If you chose to send an error instead, then this sets the default
        error to send.  Standard error reports are "unknown", "hidden",
        "no-user", or "inval".  Alternatly you can specify a custom error
        by using the string "custom=Xerror to send". RFC-1413 states that
        custom errors must begin with "X" but this program will not
        prefix the "X" for you.  Note that this behaviour differs from
        the user files.  */
char*	default_error = "unknown";

	/* This is for the special case where a socket owner uid does not resolve
        to a username.  Allowed value are as in "default_answer_type" */
char*	default_unnamed_uid_answer_type = "userid";
	/* Allowed values are as in "default_userid" with the exception that
        you cannot specify "name" */
char*	default_unnamed_uid_userid = "number";
	/* Allowed values are as with "default_error" */
char*	default_unnamed_uid_error = "unknown";
	/* Allowed values are as with "default_ostype" */
char*	default_unnamed_uid_ostype = NULL;
	/* Allowed values are as with "default_charset" */
char*	default_unnamed_uid_charset = "UTF-8";

#else /*Only need the extern declarations */
extern char*	default_configfile;
extern char*	default_authport;
extern char*	default_logfile;
extern char*	default_pidfile;
extern char*	default_user_dir;
extern char*	default_max_queries;
extern char*	default_cache_age;
extern char*	default_runas_uid;
extern char*	default_runas_gid;

extern char*	default_answer_type;
extern char*	default_userid;
extern char*	default_charset;
extern char*	default_ostype;
extern char*	default_error;

extern char*	default_unnamed_uid_answer_type;
extern char*	default_unnamed_uid_userid;
extern char*	default_unnamed_uid_error;
extern char*	default_unnamed_uid_ostype;
extern char*	default_unnamed_uid_charset;
#endif /* NEED_DEFAULTS */

#endif /* defaults_H */
