/***************************************************************************
 *   Copyright (C) 2003 by beltorak                                        *
 *   beltorak@ananzi.co.za                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <unistd.h>

#include "cidentd.h"
#include "meta.h"

#include <serverconfig.h>
#include <logutils.h>
#include <networking.h>
#include <init.h>

#define NEED_DEFAULTS
#include "defaults.h"
#undef NEED_DEFAULTS

int
main(int argc, char *argv[]) {
        int retval = cidentd_init(argc, argv);
        if( retval < 0 )
        	return retval;
        else if( retval > 0 )
        	return 0;

        if( (!state.nofork) && daemon(0, 1) ) {
        	choke("Could not run in the background");
                return -1;
        }
        fclose(stdout);
        fclose(stdin);

	if( write_pidfile() )
        	carp("Could not write pidfile");

        sockloop_do();

	/* Never reached */
	return 0;
} /* -- end main() -- */


/* END CIDENT.C */
