/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   logutils.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef logutils_H
#define logutils_H 1

#include <errno.h>


#include <state.h>

/* For convenience */
#define println(fmt, ...) printf(fmt "\n", ## __VA_ARGS__)

/* reports an error in an errno specific way */
#define choke(fmt, ...) freporterr(__FILE__, __LINE__, __FUNCTION__, \
					errno, fmt, ## __VA_ARGS__)
/* same as the above, but without errno reporting */
#define carp(fmt, ...) freporterr(__FILE__, __LINE__, __FUNCTION__, \
					0, fmt, ## __VA_ARGS__)

/* Reports a status */
#define report(fmt, ...) freportstat(fmt, ## __VA_ARGS__)

/* For debugging */
#define dreport(x, ...) if(state.debug) carp(x, ## __VA_ARGS__)


/* === function reference === */

/* Initializes the logutils subsystem */
int
init_logutils( void );

/* writes to stderr */
void
c_logf(char* str);

/* Logs an error to stderr in an errno-specific way */
void
freporterr(char* file, uint line, char* func, int errnum, char* fmt, ...);

/* Logs status to stderr */
void
freportstat(char* fmt, ...);

/* Allocates and returns a formatted string
Returns char* on success, NULL on error. */
char*
strprintf( char* fmt, ... );

/* allocates and returns a time string for logfiles */
char*
get_timestr( void );

/* Allocates and returns the string for an errno.  Masks the
incompatibility between glibc and other libraries */
char*
get_strerror_r(int errnum);


#endif /* logutils_H */
