/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   fileutils.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef fileutils_H
#define fileutils_H 1

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

/* This does not belong here :-/ */
struct key_func_pair {
        char*                keyword;
        int                  (*func)();
};


struct file_line {
        uint                 lineno;
        char*                text;
        char*                key;
        char*                value;
};


/* Counts the number of lines in a char*.
Returns the number of newlines found. */
uint
line_count(char* buf);

/* Clears an array of file line constructs. */
void
clear_file_lines(struct file_line** fl, uint count);

/* Clears a file line construct */
void
clear_file_line(struct file_line* fl);

/* Frees the memory associated with a file line */
void
free_file_line(struct file_line* fl);

/* Frees memory associated with a file line array */
void
free_file_lines(struct file_line** flines);

/* Takes a raw file buffer and returns a ptr to an array
of file_line constructs.  leading and trailing whitespace
stripped, comment and blank lines are removed. */
struct file_line*
boil_contents(char* buffer);

/* strdups a line starting at buf + *pos (includes newline); updates
*pos to point at the char after.  Returns char* on success, NULL when
no lines are left, or strndup fails.  */
char*
get_one_line(char* buf, int* pos);

/* Loads a file into a mallocated buffer.
Newline and NULL terminates it.
Returns a char* on success, NULL on error.
Calls sfopen_read(). */
char*
sfread_file(char* file, uid_t uid);

/* Reads a file stream into memory.
Returns a char* on success, NULL on error. */
char*
fread_FILE(FILE* FP);


#endif /* fileutils_H */
