/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   response.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef response_H
#define response_H 1

#include <strtotype.h>
#include <reutils.h>
#include <ansconf.h>

/* Returns the default error string; used when an error occurs
before we can set up a user's AnswerConfig */
char*
get_default_error_string( c_error_t error_type );

/* Returns an answer given the remote host and the query.
Returns NULL on error.  The answer is mallocated and must be
free'd when no longer in use.  The passed uint*'s are set
to the decoded port pair values, if possible. */
char*
get_answer_string(char* query, ulong rhost, uint* rport, uint* lport);

/* Gets the socket owner given a struct procnettcp_info*.
Returns 0 on success, a c_error_t on error. */
c_error_t
get_sock_owner(struct procnettcp_info* tcpi, uid_t* owner);

/*******
 * Answer caching utils
 *******/

/* Gets a cached answer for a user; creates one if necessary.

Returns 0 if no error, ET_UNKNOWN on error */
c_error_t
get_cached_answer(AnswerConfig** ac, uid_t owner, char* username);

/* This retrieves a cached answer for the passed uid.
If the cached answer exists, it is returned in the
passed ptr.  This also cleans out old cached answers. */
void
check_cache(AnswerConfig** ac, uid_t owner);

/* Checks to see if a cached answer is outdated.
Returns TRUE if the cached answer is outdated, FALSE
otherwise.  */
uint
is_outdated(AnswerConfig* ac);


#endif /* response_H */
