/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   pranssettings.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <logutils.h>

#include "pranssettings.h"

#include <anssettings.h>
#include <ansconf.h>
#include <state.h>

/* prints the answer type */
void
print_answer_type(AnswerConfig* ac) {
	print_default_marker_if(!ac->is_modified.answer_type);
        printf("answer type: ");
        switch( ac->answer_type ) {
        case AT_USERID:
            	println("userid");
                break;
        case AT_ERROR:
            	println("error");
                break;
        default:
            	println("Unknown Answer Type!!");
                break;
        }
} /* -- end print_answer_type() -- */

/* prints the userid type */
void
print_userid_type(AnswerConfig* ac) {
        if( ac->answer_type != AT_USERID )
        	return;
	print_default_marker_if(!ac->is_modified.userid_type);
        printf("uid type set to: ");
        switch(ac->userid_type) {
        case UT_NAME:
            	println("name");
                break;
        case UT_UID:
            	println("number");
                break;
        case UT_LITERAL:
            	println("literal string");
                print_default_marker_if(!ac->is_modified.literal_userid);
                if(ac->literal_userid)
                        println("literal userid string = {%s}",
                        		ac->literal_userid);
                else
                        println("literal userid string is null");
                break;
        default:
            	println("invalid userid type!!");
                break;
        }
} /* -- end print_userid_type() -- */

/* prints the charset */
void
print_charset(AnswerConfig* ac) {
	if( ac->answer_type != AT_USERID )
        	return;
	print_default_marker_if(!ac->is_modified.charset);
        if(ac->charset)
        	println("charset: %s", ac->charset);
        else
        	println("charset not specified");
} /* -- end print_charset() -- */

/* prints the ostype */
void
print_ostype(AnswerConfig* ac) {
	if( ac->answer_type != AT_USERID )
        	return;
	print_default_marker_if(!ac->is_modified.ostype);
        if(ac->ostype)
        	println("ostype: %s", ac->ostype);
        else
        	println("ostype not specified");
} /* --  end print_ostype() -- */

/* prints the error type */
void
print_error_type(AnswerConfig* ac) {
	print_default_marker_if(!ac->is_modified.error_type);
        printf("error type set to: ");
        switch (ac->error_type) {
        case ET_ACTUAL:
        	println("actual");
                break;
    	case ET_UNKNOWN:
            	println("unknown");
        	break;
        case ET_NOUSER:
            	println("no-user");
            	break;
        case ET_HIDDEN:
            	println("hidden");
            	break;
        case ET_INVAL:
            	println("inval");
        	break;
        case ET_CUSTOM:
            	println("custom error string");
                print_default_marker_if(!ac->is_modified.custom_error);
                if(ac->custom_error)
                        println("custom error string set to: {%s}",
                        		ac->custom_error);
                else
                        println("custom error string null");
            	break;
        default:
            	println("Unknown Error Type!!");
            	break;
        }
} /* -- end print_error_type() -- */

/* Prints the values for an answer_config */
void
print_answer_config(AnswerConfig* ac) {
	print_answer_type(ac);
        print_userid_type(ac);
        print_ostype(ac);
        print_charset(ac);
        print_error_type(ac);
} /* -- end print_answer_config() -- */

/* Prints the values for all the answer settings */
void
show_answer_settings( void ) {
        char* ans_string;
	println("Answer Settings:");
        print_answer_config(&default_ans_conf);
        gen_answer_string(&ans_string, &default_ans_conf);
        println(" -- resultant answer string {%s\\r\\n}", ans_string);

        println("For unnamed uids:");
        print_answer_config(&default_uuid_ans_conf);
        gen_answer_string(&ans_string, &default_uuid_ans_conf);
        println(" -- resultant answer string {%s\\r\\n}", ans_string);
} /* -- end print_answer_settings() -- */



/* -- end pranssettings.c -- */
