/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   serverconfig.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>

#include "serverconfig.h"

#include <defaults.h>
#include <logutils.h>
#include <logfile.h>
#include <state.h>
#include <strtotype.h>
#include <authport.h>
#include <procprivs.h>
#include <userdir.h>
#include <configfile.h>
#include <fileutils.h>


/* These are only allowed in the server file, and take one "char*" argument */
struct key_func_pair server_daemon_setting[] = {
        {  "runas-uid",                 &set_runas_uid      },
        {  "runas-gid",                 &set_runas_gid      },
        {  "auth-port",                 &set_authport       },
        {  "pidfile",                   &set_pidfile        },
        {  "logfile",                   &set_logfile        },
        {  "user-dir",                  &set_user_dir       },
        (0,0)
};


/* Sets the server settings to default values */
void
set_default_server_settings(void) {
	set_configfile(default_configfile);
	server_configfile_set = FALSE;

	set_authport(default_authport);
        server_authport_set = FALSE;

        set_logfile(default_logfile);
        server_logfile_set = FALSE;

        set_user_dir(default_user_dir);
        server_user_dir_set = FALSE;

        set_pidfile(default_pidfile);
	server_pidfile_set = FALSE;

        set_runas_uid(default_runas_uid);
	server_runas_uid_set = FALSE;

        set_runas_gid(default_runas_gid);
	server_runas_gid_set = FALSE;
} /* -- end set_default_server_settings() -- */

/* Prints the current server settings. */
void
show_server_settings( void ) {
        println("Server Settings:");
	print_configfile();
	print_authport();
        print_logfile();
        print_pidfile();
	print_user_dir();
	print_runas_uid();
	print_runas_gid();
} /* -- end show_settings() -- */

/* Sets the uid to run as */
int
set_runas_uid(char* cp_uid) {
	uid_t sv = proc_uid.uuid;
        if( strtouidt(&(proc_uid.uuid), cp_uid) ) {
        	carp("Unable to set runas_uid");
                return -1;
        }
        if( sv != proc_uid.uuid )
        	server_runas_uid_set = TRUE;

        suspend_proc_privs();
        return 0;
} /* -- end set_runas_uid() -- */

/* prints the uid to run as */
void
print_runas_uid(void) {
        struct passwd* pwd = getpwuid(proc_uid.uuid);
        char* uid;
        if(pwd) {
        	uid = pwd->pw_name;
        } else {
        	uid = "no username in /etc/passwd";
        }
	print_default_marker_if(!server_runas_uid_set);
	println("User to run as == %lu (%s)", proc_uid.uuid, uid);
        if( ! proc_root )
        	println("      Note: ignored when not root");
} /* -- end print_runas_uid() -- */

/* Sets the gid to run as */
int
set_runas_gid(char* cp_gid) {
        gid_t sv = proc_uid.ugid;
        if( strtogidt(&(proc_uid.ugid), cp_gid) ) {
        	carp("Unable to set the runas_gid");
                return -1;
        }

        if( sv != proc_uid.ugid )
                server_runas_gid_set = TRUE;
        suspend_proc_privs();
        return 0;
} /* -- end set_runas_gid() -- */

/* prints the gid to run as */
void
print_runas_gid(void) {
        struct group* grp = getgrgid(proc_uid.ugid);
        char* gid;
        if(grp) {
        	gid = grp->gr_name;
        } else {
        	gid = "no name in /etc/group";
        }
	print_default_marker_if(!server_runas_gid_set);
	println("Group to run as == %lu (%s)", proc_uid.ugid, gid);
        if( ! proc_root )
        	println("      note: ignored when not root");
} /* -- end print_runas_gid() -- */

/* Turns on debugging info */
int
set_debug( void ) {
	state.debug = TRUE;
        return 0;
} /* -- end set_debug() -- */


/* -- end serverconfig.c -- */
