/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   set_authport.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* This poorly named file handles the base networking layer */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <authport.h>
#include <state.h>
#include <strtotype.h>
#include <logutils.h>


uint	server_authport;
uint	server_authport_set;

int	main_socket;


/* Sets the authport.  0 on success, -1 on error. */
int
set_authport(char* port) {
	if( server_authport_set && (!state.cmdline) )
        	return 0;

        uint sv = server_authport;
        if( strtoport(&server_authport, port) )
                return -1;

        if( sv != server_authport )
        	server_authport_set = TRUE;
        return 0;
} /* -- end set_authport() -- */

/* Prints the current value of authport.  Prefixes with
'*' if state.show_settings and it is the default value */
void
print_authport( void ) {
	char* service;
        struct servent* sv = getservbyport(htons(server_authport), NULL);
        if( sv )
        	service = sv->s_name;
        else
        	service = "no name in /etc/services";

        print_default_marker_if(!server_authport_set);
        println("authport == %u (%s)", server_authport, service);
} /* -- end print_authport() -- */

/* binds and listens to the required port */
int
start_networking( void ) {
        main_socket = socket(AF_INET, SOCK_STREAM, 0);
        if( main_socket < 0 ) {
        	choke("Could not open socket");
                return -1;
        }

        int retval;

        struct sockaddr_in authaddr = {
        	AF_INET,
                htons(server_authport),
                INADDR_ANY
        };

        proc_to_prime_privs();
        retval = bind(main_socket, &authaddr, sizeof authaddr);
        suspend_proc_privs();
        if( retval ) {
        	choke("Could not bind to authport");
                return -1;
        }

        if( listen(main_socket, 1) ) {
        	choke("Could not listen to auth socket");
                return -1;
        }

        return 0;
} /* -- end start_networking() -- */


/* -- end set_authport.c -- */
