/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   response.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef response_H
#define response_H 1

#include <anscache.h>

/* This contains all needed info for a connection.
The sockfd and host members are set by the main thread
and the struct is passed to the responder thread. */
typedef struct connection_context {
	int			sockfd;
        ulong			localhost;
	uint			localport;
        ulong			remotehost;
        uint			remoteport;
        char*			query;
} ConnContext;

/* Initializes the response subsystem.  This includes
creating thread specific data spaces for thread global
variables. */
int
init_response( void );

/* Creates a new connection_context */
ConnContext*
new_connection_context( void );

/* Frees resources associated with a connection_context */
void
free_connection_context(ConnContext* cc);

/* The initialization routine for a specific thread */
int
init_thread( ConnContext* cc );

/* This is the main entry point for responder threads */
int
r_main( ConnContext* cc );

/* Retrives the query from the socket */
int
get_query(ConnContext* cc);

/* Creates and links a CachedAnswer */
int
build_cached_answer(CachedAnswer** ca_p, uid_t uid, char* username);

/* Decodes the port pair in the query.
Returns 0 on success, or an ERROR_TYPE code on error. */
int
decode_port_pair( ConnContext* cc );

/* Gets a socket owner by looking up the entry in
"/proc/net/tcp".  Returns 0 on success, -1 on error.
Sets the uint* to TRUE and the uid_t* to the owner
if found.  */
int
get_sock_owner(uint* found, uid_t* owner);

/* Checks to see if a cached answer is outdated.
Returns TRUE if the cached answer is outdated, FALSE
otherwise.  If the CachedAnswer or ca_file is NULL,
then it is outdated by default.  */
uint
is_outdated(CachedAnswer* ca);

/* Sends the error string out the socket.
Takes an ERROR_TYPE for an argument, although right
now this value is ignored and we use the "error:"
setting from the main config file.  Also,
we send the query right back to the offender instead
of sending (possibly incorrectly) decoded port numbers.  */
void
send_error(uint err_type);

/* Sends the specified string out the socket. */
int
send_output(char* str);


#endif /* response_H */
