/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtogidt.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <grp.h>

#include "strtotype.h"

#include <macros.h>
#include <logutils.h>

typeof(gid_t) GID_T_MAX = -1;

/* Translates a string to the corresponding gid.  0 on success, -1 on error */
int
strtogidt(gid_t* gid, char* cp_gid) {
        if( is_nil(cp_gid) ) {
        	carp("gid is NULL");
                return -1;
        }

	/* First check to see if the string is a number */
        char* endptr;
        ulong ul_gid = strtoul(cp_gid, &endptr, 10);
        if( ! *endptr ) {
        	if( ul_gid > GID_T_MAX ) {
                	carp("gid > max allowed for system");
                        return -1;
                }

                *gid = (gid_t) ul_gid;
                return 0;
        }
        /* Otherwise we try to find the entry in /etc/group */
        struct group* grp = getgrnam(cp_gid);
        if( !grp ) {
        	choke("gid does not exist in /etc/group");
                return -1;
        }

        *gid = grp->gr_gid;
        return 0;
} /* -- end strtogidt() -- */



/* -- end strtogidt.c -- */
