/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   userdir.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>

#include "userdir.h"

#include <macros.h>
#include <state.h>
#include <logutils.h>

char*	server_user_dir = NULL;
uint	server_user_dir_set = FALSE;

/* Sets the user_dir.  Returns 0 on success, -1 on error. */
int
set_user_dir(char* dir) {
	char* sv;
	if( is_nil(server_user_dir) )
        	sv = NULL;
        else
        	sv = server_user_dir;

        if( is_nil(dir) )
        	server_user_dir = NULL;
        else {
        	server_user_dir = strdup(dir);
                if( ! server_user_dir ) {
                	carp("Could not store user data dir");
                        return -1;
                }
        }

        if( ! strings_eq(sv, server_user_dir) )
        	server_user_dir_set = TRUE;
        return 0;
} /* -- end set_user_dir() -- */

/* Prints the user_dir.  Prefixes with '*' if needed. */
void
print_user_dir( void ) {
        print_default_marker_if(!server_user_dir_set);
        if( server_user_dir )
        	println("user_dir == %s", server_user_dir);
        else
        	println("Not using user files");
} /* -- end print_user_dir() -- */


/* -- end userdir.c -- */
