/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   serverconfig.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef serverconfig_H
#define serverconfig_H 1

#include <fileutils.h>


extern struct key_func_pair server_daemon_setting[];

/* Sets the server settings to default values */
void
set_default_server_settings(void);

/* Prints the current server settings. */
void
show_server_settings( void );

/* Sets the uid to run as */
int
set_runas_uid(char* cp_uid);

/* prints the uid to run as */
void
print_runas_uid(void);

/* Sets the gid to run as */
int
set_runas_gid(char* cp_gid);

/* prints the gid to run as */
void
print_runas_gid(void);

/* Turns on debugging info */
int
set_debug( void );


#endif /* serverconfig_H */
