/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   logfile.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef logfile_H
#define logfile_H 1

extern char*		server_logfile;
extern uint		server_logfile_set;

extern char*		server_pidfile;
extern uint		server_pidfile_set;

/* Starts logging -- everything going to stderr now goes to the logfile */
int
start_logging( void );

/* Opens the pidfile.
Returns 0.
It is not an error if the pidfile cannot be written. */
int
open_pidfile( void );

/* Checks the validity of a pidfile. Returns TRUE if a process
with that pid exists, FALSE otherwise */
uint
check_pid( void );

/* Writes the pidfile.  Since this is a type of log,
it is defined here.  */
int
write_pidfile( void );

/* Sets the logfile.  Returns 0 on success, -1 on error. */
int
set_logfile(char* logfile);

/* Prints the logfile.  Prefixes with '*' if needed. */
void
print_logfile( void );

/* Sets the pidfile. Returns 0 on success, -1 on error. */
int
set_pidfile(char* pidfile);

/* Prints the pidfile.  Prefixes with '*' if needed. */
void
print_pidfile( void );


#endif /* logfile_H */
