/* This provides a set of convenience macros. */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* Checks to see if a (string) ptr is NULL or NIL */
#define is_nil(str)		( str && *(str) ? FALSE : TRUE )

/* Checks to see if strings match */
#define strings_eq(s1, s2)	((s1 == s2) || ( s1 && s2 && (strcmp(s1, s2) == 0)) ? TRUE : FALSE )

/* NULLs a ptr after freeing it */
#define null_free(ptr)		free(ptr); ptr = NULL

/* Checks to see if a ptr is not null beforehand */
#define if_notnull_free(ptr)	if(ptr) { null_free(ptr); }

/* end macros.h */
