/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   runas_uid.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This test checks the default_runas_uid/gid in "defaults.h"            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <strtotype.h>
#define NEED_DEFAULTS
#include <defaults.h>
#undef NEED_DEFAULTS
#include <logutils.h>
#include <state.h>

int
main( void ) {
	uid_t uid;
        struct state_info state;
        state.initting = TRUE;
	if( strtouidt(&uid, default_runas_uid) ) {
        	println("Cannot set default_runas_uid");
        	exit(1);
        }

        if( ! uid ) {
        	println("Cannot set default_runas_uid to root!!");
        }
	exit(0);
}

/* -- end runas_uid.c -- */
