/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   strtoport.c part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>

#include "strtotype.h"

#include <macros.h>
#include <logutils.h>
#include <state.h>

/* Translates a string to a port number.  0 on success, -1 on error. */
int
strtoport(uint* ui_port, char* cp_port) {
	if( is_nil(cp_port) ) {
                carp("Passed NULL as port");
                return -1;
        }
        char* end;
	ulong tmp = strtoul(cp_port, &end, 10);
	if( (*end != 0) && state.initting ) {
        	struct servent* sv = getservbyname(cp_port, NULL);
                if( ! sv ) {
                	carp("Port name does not exist in /etc/services");
                	return -1;
                }
                *ui_port = ntohs(sv->s_port);
                return 0;
        } else if( *end != 0 ) {
        	carp("Illegal port specification");
                return -1;
        }

        if( (tmp < 1) || (tmp > 65535) ) {
        	carp("Port not in valid range");
                return -1;
        }

        *ui_port = (uint) tmp;
	return 0;
} /* -- end strtoport() -- */


/* -- end strtoport.c -- */
