/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   sfopen.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef sfopen_H
#define sfopen_H 1

#include <stdio.h>


/* These routines open a file while satisfying
proc priv requirements. */

/* Opens a file for writing; the file must not exist.
Returns the file descriptor or -1 on error.  Does not report. */
int
sopen_write(char* file);

/* Opens a file for writing.  Returns FILE* on success,
NULL on error.  It is an error for the file to exist.  */
FILE*
sfopen_write(char* file);

/* Opens a file for appending. */
FILE*
sfopen_append(char* file);

/* Opens a file for reading. Calls sfcheck_read().
Returns FILE* on success, -1 on error. */
FILE*
sfopen_read(char* file, uid_t uid);

/* Checks that a file is safe to read.
Returns 0 on success, -1 on failure:
    if uid != 0
        FAIL if file owner != uid or root
*/
int
sfcheck_read(FILE* FP, uid_t uid);

/* Checks that a file is not writable by a uid, any
of it's group memberships, or world.  Returns 0 on success,
-1 on failure.  */
int
sfcheck_readonly(FILE* FP, uid_t uid);


#endif /* sfopen_H */

