/***************************************************************************
 *   Copyright (C) 2004 by Trevor "beltorak" Torrez                        *
 *   beltorak@phreaker.net                                                 *
 *   anssettings.h, part of cidentd version 0.2                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef anssettings_H
#define anssettings_H 1

#include <fileutils.h>
#include <ansconf.h>

/* This is used to create a new answer_config and overridden
by the user files */
extern AnswerConfig default_ans_conf;
/* The special case where a socket is owned by an unnamed uid */
extern AnswerConfig default_uuid_ans_conf;

extern struct key_func_pair uuid_answer_setting[];
extern struct key_func_pair user_answer_setting[];

/* Sets the default answer settings */
int
set_default_answer_settings( void );

/* Sets the answer type for an answer_config.  0 on success, -1 on error. */
int
set_ans_type(AnswerConfig* ac, char* ans_type);

/* Sets the userid.  0 on success, -1 on error */
int
set_userid_type(AnswerConfig* ac, char* userid);

/* Same as above, but rejects "name" types */
int
set_uuid_userid_type(AnswerConfig* ac, char* userid);

/* Sets the charset.  NULL means not to carp a charset. */
int
set_charset(AnswerConfig* ac, char* charset);

/* Sets the ostype to reply with.  NULL means not
to specify an OS. */
int
set_ostype(AnswerConfig* ac, char* ostype);

/* sets the error. */
int
set_error_type(AnswerConfig* ac, char* error);

/* The loop for setting an answer setting from a file_line struct.
Returns -1 on error (includes errors from the called function),
+1 on a successful call to a function, or 0 if the function was
not found */
int
answer_setting_loop(struct file_line* fl, struct key_func_pair* kfp, AnswerConfig* ac);


#endif /* anssettings_H */
